#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'на dev7 2 часа, в продакшине ожидается порядка 30 минут (select заметно быстрее выполняется)',
  comment => 'чиним регион тем баннерам у которых он пустой (предположительно ставший пустым в результате ошибки при копировании)',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use GeoTools;
use BS::ResyncQueue;
use List::MoreUtils qw/uniq/;
use utf8;

local $Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

$log->out('START');

my $date_of_release_with_error = '2013-08-12'; # дата когда выехал релиз с группами, в котором, скорей всего, появилась ошибка
my $total_updated_pids = 0;

$log->out('fetching problematic campains/pids from database');
my $camps = get_all_sql(PPC_HEAVY, "SELECT c.cid, c.geo, GROUP_CONCAT(p.pid) as pids 
                                      FROM campaigns c 
                                      JOIN phrases p FORCE INDEX (LastChange) on p.cid = c.cid and p.geo is null and p.LastChange >= ?
                                  GROUP BY c.cid", $date_of_release_with_error);
$log->out('fetched ' . scalar(@$camps) . ' campaigns');
foreach my $camp (@$camps) {
    $log->out("processing cid=$camp->{cid}");
    #проверяем что в кампании есть баннеры с выставленным регионом, и он у всех баннеров одинаков
    #и соответствует единому региону, который когда-то устанавливали в параметрах кампании
    my $geoflag;
    $camp->{geo} = refine_geoid($camp->{geo}, \$geoflag);
    my $banners_geo = get_one_column_sql(PPC_HEAVY, "SELECT DISTINCT geo FROM phrases WHERE cid = ? AND geo IS NOT NULL", $camp->{cid});
    @$banners_geo = uniq map { $_ = refine_geoid($_, \$geoflag) } @$banners_geo;
    my $correct_geo;

    if (@$banners_geo == 1) {
        $correct_geo = $banners_geo->[0];
        $log->out("Detecting geo on cid=$camp->{cid}: all banners have same geo=$correct_geo");
    } elsif (defined $camp->{geo}) {
        $correct_geo = $camp->{geo};
        $log->out("Detecting geo on cid=$camp->{cid}: banners have different geo (or have no geo selected), but camp has geo=$correct_geo");
    } else {
        $correct_geo = 0;
        $log->out("Detecting geo on cid=$camp->{cid}: whole world is correct region, geo=$correct_geo");
    }
    
    my $geo = refine_geoid($correct_geo, \$geoflag);
    my @pids = split ',', $camp->{pids};
    foreach my $pid (@pids) {
        $log->out("trying to update pid with geo=$geo (campaign geo=".(defined $camp->{geo} ? $camp->{geo} : '') .", banners geo=".(@$banners_geo ? $banners_geo->[0] : '')."): cid=$camp->{cid}, pid=$pid");
        my $rows_updated = do_update_table(PPC, 'phrases', {
            geo => $geo,
            LastChange__dont_quote => 'LastChange',
            statusShowsForecast => 'New'
        }, where => {cid => $camp->{cid}, 
                     pid => $pid,
                     geo__is_null => 1});
        unless ($rows_updated > 0) {
            $log->out("skip cid=$camp->{cid}, pid=$pid: geo is not null (or pid not exists)");
            next;
        }

        my $bids = get_one_column_sql(PPC, "SELECT bid FROM banners where cid = ? AND pid = ?", $camp->{cid}, $pid);
        if ($bids && @$bids) {
            do_update_table(PPC, 'banners', {
                geoflag => $geoflag,
                LastChange__dont_quote => 'LastChange',
                statusPostModerate__dont_quote => "IF(statusPostModerate = 'Rejected', 'Rejected', 'No')",
                statusModerate__dont_quote => "IF(statusModerate = 'New', 'New', 'Ready')"
            }, where => {bid => $bids});

            bs_resync([map { { cid => $camp->{cid}, pid => $pid, bid => $_ } } @$bids]);
        } else {
            bs_resync([{ cid => $camp->{cid}, pid => $pid }]);
        }
        $total_updated_pids ++;
    }

}
$log->out("total updated pids qty: $total_updated_pids");
$log->out('FINISH');

