#!/usr/bin/perl -w

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '10 минут',
  comment => "Восстановление ссылок у баннеров, которые были потеряны
    при операции 'Редактирование текстов'"
}

=cut


use strict;
use warnings;
use utf8;

use lib::abs '../protected';

use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::HashUtils;
use Yandex::TimeCommon;
use Models::Banner;
use ScriptHelper;

$Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

use RBAC2::Extended;
use MailNotification;

my $rbac = new RBAC2::Extended(RBAC, RBAC_SLAVE);
die "Can't connect to RBAC" if !defined $rbac || !$rbac->InitReq(1);

# ошибка отсюда https://jira.yandex-team.ru/browse/DIRECT-24311
my $start_date = '20131114';
my $end_date = '20131125';

$log->out("start");

my %banners;
foreach my $logdate (get_distinct_dates($start_date, $end_date)) {
    my $commands = get_cmd($logdate);
    $log->out($logdate . " found commands " . scalar @$commands);
    foreach my $cmd (@$commands) { 
        $banners{$_} = {logtime => $cmd->{logtime}, logdate => $logdate, cid => $cmd->{cid}} foreach $cmd->{bids} ? @{$cmd->{bids}} : (); 
    }
    $log->out($logdate . " found banners " . scalar keys %banners);
}

$log->out("total banners found " . scalar keys %banners);

my %logdates;
while (my ($bid, $value) = each %banners) {
    $logdates{$value->{logdate}}->{$bid} = $value;
}

my ($total_wrong_banners, $total_restored_banners) = (0, 0);
while (my ($logdate, $banners) = each %logdates) {
    
    for my $chunk (sharded_chunks bid => [keys %$banners]) {

        my $wrong_bids = get_one_column_sql(PPC_HEAVY(shard => $chunk->{shard}),
            ["SELECT bid FROM banners WHERE IFNULL(vcard_id, 0) > 0 AND IFNULL(href, '') = '' AND ",
                {bid => $chunk->{bid}}]) || [];
        $log->out($logdate . " found wrong banners " . scalar @$wrong_bids);        
        next unless @$wrong_bids;
        
        $total_wrong_banners += @$wrong_bids;
        $log->out($logdate . " wrong bids=" . join ",", @$wrong_bids);
        my $wrong_banners = hash_cut $banners, @$wrong_bids;
        $total_restored_banners += restore_hrefs($wrong_banners, $logdate, $chunk->{shard});
    }
} 

$log->out("total: total banners - $total_wrong_banners restored banners - $total_restored_banners");
$log->out("finish");

sub restore_hrefs {
    
    my ($banners, $logdate, $shard) = @_;
    my $min_logtime = [sort {$a->{logtime} cmp $b->{logtime}} values %$banners]->[0]->{logtime};
    
    my %cids;
    $cids{$_->{cid}} = 1 for values %$banners;
    my $commands = find_save_cmd($logdate, $min_logtime, [keys %cids]);
    my %banners_href;
    
    for my $cmd (@$commands) {
        while (my ($bid, $href) = each %{$cmd->{banners}}) {
            $banners_href{$bid} = $href;         
        }  
    }

    my @bids = grep {$banners_href{$_}} keys %$banners;
    my $source_banners = get_banners(PPC(shard => $shard), \@bids);
    my $restored_hrefs = 0;
    foreach my $banner (@$source_banners) {
        
        $banner->{href} = $banners_href{$banner->{bid}}->{href};
        $banner->{domain} = $banners_href{$banner->{bid}}->{domain}; 
        
        # будет отправлено письмо
        MailNotification::save_UID_rbac($banner->{uid}, $rbac);        
        update_banner_only(get_dbh(PPC(shard => $shard)), $banner, $banner->{uid}, {
            ignore_vcard => 1, 
            ignore_sitelinks => 1
        });
        
        $log->out(sprintf "restore href for bid=%d to href=%s domain=%s",
             $banner->{bid}, $banner->{href}, $banner->{domain}); 
        delete $banners->{$banner->{bid}};
        $restored_hrefs++;
    }  
    
    if (my @bids = keys %$banners) {
        $log->out("couldn't find href for " . scalar(@bids) . " banners");
        $log->out("couldn't find href for bids=" . join ",", @bids);
    }
    
    return $restored_hrefs;
}

sub get_cmd {
    
    my $date = shift;
    
    my $sql = sprintf <<EOS, $date;
        SELECT
            param, logtime, cid
        FROM logcmd_%s
        WHERE cmd = 'showCampMultiEditLight'
        ORDER BY logtime
EOS
    
    my $requests = get_all_sql(PPCLOG_HEAVY, $sql);
    foreach my $req (@$requests) {
        next unless $req->{param} =~ /bids=(\S+)/;
        $req->{bids} = [grep {/^\d+$/} split /,/, $1]; 
    }
    
    return $requests;   
}


sub find_save_cmd {

    my ($logdate, $min_logtime, $cids) = @_;
    
    my $requests = get_all_sql(PPCLOG_HEAVY, [
        "SELECT param
        FROM logcmd_$logdate
        WHERE cmd = 'bannersMultiSave'
            AND param LIKE '%is_light=1%'
            AND logtime >= ? AND ",
        {cid => $cids},
        "ORDER BY logtime"], $min_logtime); 
    foreach my $req (@$requests) {
        my %banners;
        while ($req->{param} =~ m/((?:^|\s)href\-(\d+)=(\S+))/g) {
            $banners{$2}->{href} = $3;
        }
        while ($req->{param} =~ m/(domain\-(\d+)=(\S+))/g) {
            $banners{$2}->{domain} = $3;
        }
        
        my @to_delete = grep { !($banners{$_}->{href} && $banners{$_}->{domain}) } keys %banners;
        delete @banners{@to_delete} if @to_delete;
        $req->{banners} = \%banners; 
    }
    
    return $requests;
}

sub get_banners {

    my ($dbh, $bids) = @_;    
    
    my $sql = qq[SELECT b.bid, b.uid, title, body, href, ifnull(domain,'') domain, ifnull(domain_redir,'') domain_redir, sitelinks_set_id,
                    ifnull(vc.phone,'') phone, ifnull(vc.contactperson,'') contactperson, ifnull(vc.worktime,'') worktime, ifnull(vc.street,'') street, ifnull(vc.house,'') house, ifnull(vc.build,'') build, ifnull(vc.apart,'') apart, ifnull(vc.metro,'') metro, ifnull(vc.city,'') city, ifnull(vc.country,'') country, ifnull(vc.name,'') name, vc.geo_id,
                    vc.im_client, vc.im_login, vc.extra_message, vc.contact_email, vc.org_details_id,
                    b.statusModerate, b.phoneflag, statusPostModerate, b.statusSitelinksModerate,
                    vc.address_id,
                    bim.image_hash as image, bim.statusShow as image_statusShow
               FROM banners b
                    LEFT JOIN vcards vc ON vc.vcard_id = b.vcard_id
                    LEFT JOIN banner_images bim on bim.bid = b.bid];
    return get_all_sql($dbh, [$sql, WHERE => {'b.bid' => $bids}]); 
}
