#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "1 час",
  comment => "Чиним визитки, которые по ошибке получили чужой cid"
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use Yandex::Retry;
use ScriptHelper;
use ShardingTools;

use utf8;

$log->out('START');

for my $shard (ppc_shards()) {
    $log->out("Processing shard $shard");

    my $bad_vcards = get_all_sql(PPC_HEAVY(shard => $shard),
        'SELECT b.vcard_id
              , v.cid AS v_cid
              , p.cid AS p_cid
              , count(b.bid) as count
           FROM banners b
                JOIN phrases p USING(pid)
                JOIN vcards v USING(vcard_id)
          WHERE v.cid != p.cid
       GROUP BY vcard_id'
    ) || [];

    foreach my $vcard (@$bad_vcards) {
        $log->out("Vcard $vcard->{vcard_id} has cid $vcard->{v_cid}, but phrases cid is $vcard->{p_cid}, banners count with this vcard $vcard->{count}");
        relaxed times => 4, sub {
            $log->out("Update vcard $vcard->{vcard_id} set cid $vcard->{p_cid}");
            do_update_table(PPC(shard => $shard), 'vcards',
                { cid => $vcard->{p_cid} },
                where => {
                    vcard_id => $vcard->{vcard_id},
                    cid      => $vcard->{v_cid},
                }
            );
        };
    }
}

$log->out('FINISH');
