#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'на dev7 30 минут, на production ожидается порядка 5-10 минут, за счет более быстрой выборки',
  comment => 'отправляем сайтлинки, подвисшие по ошибке в состоянии "черновик" на модерацию 
              (только для баннеров, которые уже уходили на модерацию)',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use utf8;

$log->out('START');

$log->out('fetching problematic banners/sitelinks');
my $banners = get_all_sql(PPC_HEAVY(shard => 'all'), ["select cid, bid, statusModerate, sitelinks_set_id
                                                         from banners",
                                                        where => { sitelinks_set_id__is_not_null => 1,
                                                                   statusSitelinksModerate => 'New', 
                                                                   statusModerate__ne => 'New' } ]);
$log->out('fetched ' . scalar(@$banners) . ' banners');
foreach my $b (@$banners) {
    $log->out($b);
    my $rows_updated = do_update_table(PPC(cid => $b->{cid}), 'banners', 
                                                {  statusSitelinksModerate => 'Ready' }, 
                                                where => {  bid => $b->{bid},
                                                            sitelinks_set_id__is_not_null => 1,
                                                            statusSitelinksModerate => 'New', 
                                                            statusModerate__ne => 'New'});
    $log->out("not updated: bid=$b->{bid}") unless ($rows_updated > 0);
}
$log->out('FINISH');

