#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "3 минуты",
  comment => q!
устанавливаем в кампаниях, которые отсутствуют в модерации statusModerate=New
перед запуском нужно
scp root@ppcdev-precise:/tmp/campaigns_mod_status_cids /tmp/campaigns_mod_status_cids
!
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use Yandex::ListUtils;
use ScriptHelper;


use utf8;

$log->out('START');

open(F, "/tmp/campaigns_mod_status_cids") || die $!;

my @rows = <F>;
foreach my $cids (chunks \@rows, 4000) {
	my $cids = [map {m/(\d{3,})/} @$cids];
	$log->out(join ' ', @$cids);
	my $affected = do_update_table(PPC(shard=>'all'), 'campaigns', {statusModerate=>'New'}, 
		           where => {cid => $cids, statusModerate=>'Yes'});
	$log->out(sprintf("Updated %d rows (from %d cids)", $affected, scalar(@$cids)));
	sleep(3);
}

$log->out('FINISH');

