#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by lena-san
# .migr
[
  {
    type => 'sql',
    webstop => "0",
    db => "ppcdict",
    when => 'after',
    time_estimate => "меньше секунды",
    sql => "UPDATE ppc_properties SET value = '2013-12-01' WHERE name = 'last_month_agency_stat';"
  },
  {
    type => 'manual',
    when => 'after',
    time_estimate => "меньше минуты",
    text => "на машине с пакетом yandex-direct-scripts-offreps (ppcscripts01f) нужно 
        прибить работающий экземпляр скрипта ppcCollectAgencyOfflineReportStat.pl"
  },
  {
    type => 'script',
    when => 'after',
    time_estimate => "15 минут",
    comment => "Перед запуском сделать
        scp ppcdev2.yandex.ru:/home/ppalex/agency_clients_month_stat_recalced.tsv /tmp"
  }
]

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use Yandex::Retry;
use ScriptHelper;

use utf8;

$log->out('START');
open (my $fh, '<', '/tmp/agency_clients_month_stat_recalced.tsv') or $log->die("Can't open file agency_clients_month_stat_recalced.tsv: $!");

while (my $line = <$fh>) {
    chomp $line;
    my ($stat_date, $AgencyID, $ClientID, $banners_moderate, $banners_moderate_declined) = split ("\t", $line);

    relaxed times => 3, sub {
        my $res = do_update_table(MONITOR, 'agency_clients_month_stat',
            {
                banners_moderate => $banners_moderate,
                banners_moderate_declined => $banners_moderate_declined,
            },
            where => {
                stat_date => $stat_date,
                AgencyID => $AgencyID,
                ClientID => $ClientID,
                banners_moderate => 0,
                banners_moderate_declined => 0,
            }
        );
        my $action = $res eq '0E0' ? 'skipped' : 'updated';
        $log->out("$action:\t$stat_date\t$AgencyID\t$ClientID\t$banners_moderate\t$banners_moderate_declined");
    }
}

close ($fh);
$log->out('FINISH');

