#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "1 минуту",
  comment => qq{
    Вызов скрипта: /var/www/ppc.yandex.ru/deploy/20140226_vcards_phone_fix.pl 3
    цифровой параметр вызова - это время на которое засыпаем между апдейтами в базу
    фиксим в визитках номера типа +8#800}
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";
use List::MoreUtils qw/uniq/;

use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use ScriptHelper;

use Yandex::Retry;

use utf8;

$log->out('START');

my $SLEEP_TIME = 3;
if($ARGV[0] && $ARGV[0] =~ /\d+/ && $ARGV[0] > 0){
    $SLEEP_TIME = $ARGV[0];
}

my $vcards_with_wrong_phone = get_hashes_hash_sql(PPC_HEAVY(shard => 'all'), "select vcard_id, phone, cid from vcards where phone like '+8#800%'");
$log->out($vcards_with_wrong_phone);
my @cids = uniq map {$vcards_with_wrong_phone->{$_}->{cid}} keys %$vcards_with_wrong_phone;
my $vcards_with_wrong_phone_cid = {};
for my $vcard_id (keys %$vcards_with_wrong_phone){
    my $cid = $vcards_with_wrong_phone->{$vcard_id}->{cid};
    if(exists $vcards_with_wrong_phone_cid->{$cid}){
        push( @{$vcards_with_wrong_phone_cid->{$cid}}, $vcard_id ); 
    } else {
        $vcards_with_wrong_phone_cid->{$cid} = [];
        push( @{$vcards_with_wrong_phone_cid->{$cid}}, $vcard_id ); 
    }
}

my $banners_to_resync = get_all_sql(PPC(cid => \@cids), ["select cid, bid from banners", where => {vcard_id => [keys %$vcards_with_wrong_phone]}]);
my %banners_to_resync_cid;
for my $banner (@$banners_to_resync){
    if(exists $banners_to_resync_cid{$banner->{cid}}){
        push( @{$banners_to_resync_cid{$banner->{cid}}}, $banner->{bid} ); 
    } else {
        $banners_to_resync_cid{$banner->{cid}} = [];
        push( @{$banners_to_resync_cid{$banner->{cid}}}, $banner->{bid} ); 
    }
}

foreach_shard cid => \@cids, chunk_size => 1000, sub {
    my ($shard, $cids_chunk) = @_;

    my %cids_chunk_hash = map { $_ => 1 } @$cids_chunk;

    my @banners_to_resync_this_shard;
    my @vcards_to_update_this_shard;
    for my $cid (@$cids_chunk){
        push(@vcards_to_update_this_shard, @{$vcards_with_wrong_phone_cid->{$cid}}); 
        for my $bid (@{$banners_to_resync_cid{$cid}}){
            push(@banners_to_resync_this_shard, [$cid, $bid]);
        }
    }

    $log->out("vcards for update at shard $shard: ", join(',', @vcards_to_update_this_shard));

    relaxed times => $SLEEP_TIME, sub {
            do_in_transaction {
                do_sql(PPC(shard=>$shard), ["update vcards set phone=replace(phone, '+', '')",
                    where => { vcard_id => \@vcards_to_update_this_shard, phone__like => '+8#800%' }]);

                do_mass_insert_sql( PPC(shard=>$shard),
                    'INSERT IGNORE INTO bs_resync_queue (cid, bid) VALUES %s', \@banners_to_resync_this_shard);
            };

    };
};


$log->out('FINISH');
