#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '1-2 минуты',
  comment => 'Затираем wallet_cid в кампаниях, сконвертированных копированием',
}

=cut

use strict;
use warnings;

use lib::abs '../protected';

use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use ScriptHelper;
use ShardingTools;
use Yandex::ListUtils;

use utf8;

$log->out('START');

foreach_shard shard => [ppc_shards()], sub {
    my ($shard) = @_;

    $log->msg_prefix("[shard_$shard]");

    $log->out('Fetching cids to fix');
    my $cids_to_fix = get_one_column_sql(PPC_HEAVY(shard => $shard), [q(
        SELECT c.cid
        FROM campaigns c
        INNER JOIN campaigns wc ON c.wallet_cid = wc.cid
        WHERE
            IFNULL(c.currency, 'YND_FIXED') = 'YND_FIXED'
            AND c.currencyConverted = 'Yes'
            AND c.archived = 'Yes'
            AND c.type IN ('text', 'wallet')
            AND wc.type <> 'wallet'
    )]);
    if ($cids_to_fix && @$cids_to_fix) {
        my $cids_to_fix_cnt = scalar @$cids_to_fix;
        $log->out("Found $cids_to_fix_cnt campaigns to fix");
        for my $cids_chunk (chunks $cids_to_fix, 100) {
            $log->out('Fixing cids chunk:', $cids_chunk);
            my $updated_cnt = do_update_table(PPC(shard => $shard), 'campaigns', {wallet_cid => 0}, where => {cid => $cids_chunk});
            $log->out("Fixed cids chunk. Updated $updated_cnt rows.");
        }
    } else {
        $log->out('No campaigns to fix found');
    }
};

$log->out('FINISH');
