#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by zhur
# .migr
[
{
  type => 'sql',
  webstop => 0,
  db => 'ppcdict',
  when => 'before',
  time_estimate => '5 секунд',
  sql => 'alter table geo_regions add key(ename), add key(ua_name), add key(tr_name)',
  comment => 'Добавляем индексы для всех языков в geo_regions',
},
{
  type => 'script',
  when => 'after',
  time_estimate => "15 минут",
  comment => "Заменяем некоторые распространенные опечатки в названиях городов в визитках"
}
]

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use Yandex::Retry qw/relaxed/;
use ShardingTools qw/ppc_shards/;
use BS::ResyncQueue qw/bs_resync/;
use GeoTools qw/get_geoid_by_cityname/;

use utf8;
use open ':std' => ':utf8';

# Правильное_название => [ неправильные варианты ]
my %cities = (
    'Москва' => [ 'Моcква', 'Москвва', 'Моска', 'г. Москва', 'Москвам', 'Москв', 'Моск', 'Москве', 'Мрсква', 'Мсоква', 'Моква' ],
    'Санкт-Петербург' => [ 'Санкт-Петербур', 'Санк Петербург', 'Санк-Петербур', 'Санкт Петербург',
        'Санкт-Петебург', 'Санкт-Перебург', 'Санкт-Петербруг', 'С-Петербург', 'Санкт-Петрбург' ],
    'Нижний Новгород' => [ 'Нижний-Новгород', 'Н.Новгород' ],
    'Владивосток' => [ 'Владивсток' ],
    'Кемерово' => [ 'Кемеро' ],
    'Волгоград' => [ 'Волгорад' ],
    'Хабаровск' => [ 'Хабарвоск' ],
    'Салехард' => [ 'Слехард' ],
    'Краснодар' => [ 'Карснодар', 'г. Краснодар' ],
    'Омск' => [ 'г. Омск' ],
    'Екатеринбург' => [ 'Екатеринубрг', 'г. Екатеринбург', 'Екатеринбур', 'Екатернбург' ],
    'Тверь' => [ 'Тверь.' ],
    'Набережные Челны' => [ 'г.Набережные Челны' ],
    'Великий Новгород' => [ 'Великий Новгорол' ],
    'Челябинск' => [ 'Чеялбинск' ],
    'Новокузнецк' => [ 'Новоукзнецк' ],
    'Ярославль' => [ 'Ярославь' ],

);

$log->out('START');

for my $city_correct (keys %cities) {
    my $city_geo_id = get_geoid_by_cityname($city_correct);
    for my $shard (ppc_shards()) {
        $log->msg_prefix("shard $shard:");
        $log->out($city_correct);
        my $rows = get_all_sql(PPC(shard => $shard), ["
            select vcard_id, city
            from vcards",
            where => {
                city => $cities{$city_correct},
            },
        ]);
        $log->out($rows);
        my $updated = relaxed times => 2, sub {
            my $vcard_ids = [ map { $_->{vcard_id} } @$rows ];
            my $bids_resend = get_all_sql(PPC(shard => $shard), ["
                select b.cid, b.bid
                from banners b
                join vcards vc using(vcard_id)",
                where => { 'vc.vcard_id' => $vcard_ids }
            ]);
            if (@$bids_resend) {
                $log->out({ bs_resync => $bids_resend });
                bs_resync($bids_resend);
            }
            return int do_update_table(PPC(shard => $shard), 'vcards', { city => $city_correct }, where => {
                vcard_id => $vcard_ids,
                city => $cities{$city_correct},
                geo_id => $city_geo_id,
            });

        };
        $log->out("$updated rows updated");
    }
}
$log->msg_prefix('');

$log->out('FINISH');

