#!/usr/bin/perl

use my_inc "..";

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "2.5 часа",
  comment => "
  
    Отправляем на модерацию условия показа, которые не отправляли из за ошибки DIRECT-30058
    Будет отправленно 767 условий	
  
    запускать так ./20140328_fix_group_draft.pl --sleep-coef=1
    если будет слишком грузить ppc - можно перезапустить с параметром --sleep-coef 3
  "
}

=cut

use strict;
use warnings;
use utf8;

use lib::abs '../protected';
use Settings;
use Yandex::DBTools;
use ScriptHelper;
use ShardingTools;
use Yandex::ListUtils qw/chunks/;
use Getopt::Long;
use Yandex::Retry qw/relaxed/;

my $sleep_coeff = 1;
GetOptions(
    'sleep-coeff=i' => \$sleep_coeff
);
$sleep_coeff = 1 unless defined $sleep_coeff;

my $shard;
$log->out('start');
foreach $shard (ppc_shards()) {
    
    $log->msg_prefix("shard_$shard ");
    while (my $pids = get_next_pids($shard)) {
        
        $log->out("got " . scalar(@$pids) . " groups");
        
        relaxed times => $sleep_coeff, sub {
            send_to_moderate($shard => $pids)
        };
    }
}
$log->out('finish'); 


my ($max_pid, $current_pid);
sub get_next_pids {
    
    my $shard = shift;

    $max_pid = get_one_field_sql(PPC(shard => $shard), 'SELECT MAX(pid) FROM phrases') unless defined $max_pid;
    $current_pid = 0 unless defined $current_pid;
    
    my $pids;
    while (!$pids) {
        my $t = time;
        $pids = get_one_column_sql(PPC_HEAVY(shard => $shard), "
            SELECT p.pid
            FROM
                phrases p
                JOIN campaigns c USING(cid)
                JOIN banners b USING(pid)
            WHERE
                p.statusModerate = 'New' AND b.statusModerate <> 'New'
                AND c.archived = 'No'
                AND p.pid BETWEEN ? AND ?", $current_pid, $current_pid + 150000);
        $log->out("query duration: " . (time - $t) . "s");
        last if $current_pid > $max_pid;               
        $current_pid += 150000;
    }
    
    return $pids;
}

sub send_to_moderate {
    my ($shard, $pids) = @_;
    
    foreach my $ids (chunks $pids, 1000) {
        $log->out("send to moderate pids: " . join ",", @$ids);
        my $affected = do_sql(PPC(shard => $shard), [
            "UPDATE phrases SET statusModerate = 'Ready', LastChange = LastChange",
            WHERE => {pid => $ids, statusModerate => 'New'}
        ]);
        $log->out("affected rows " . ($affected + 0));
    }
}
