#!/usr/bin/perl

use my_inc "..";

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "20 минут на devtest",
  comment => "меняем хеши у всех фраз в ppc:mcb_phrases, ppcdict:mcb_theme_phrases"
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use PhraseText;
use ShardingTools;
use Yandex::Retry qw/relaxed/;

use utf8;

my $SLEEP_COEF = 1;
GetOptions(
    "sleep-coef=s" => \$SLEEP_COEF,
);

$log->out('START');

my $chunk = 10_000;
for my $shard (ppc_shards()) {
    $log->out("shard $shard");
    my ($min, $max) = get_one_line_array_sql(PPC(shard => $shard), "select min(id), max(id) from mcb_phrases");
    while ($min < $max) {
        $log->out("id $min/$max");
        my $phrases = get_all_sql(PPC(shard => $shard), ["select id, phrase, norm_hash from mcb_phrases", where => { id__between => [ $min, $min + $chunk -1] }]);
        $log->out($phrases);
        my %id2hash = map { $_->{id} => get_phrase_props($_->{phrase})->{norm_hash} } @$phrases;
        my $id2hash_sql = sql_case(id => \%id2hash);
        my @old_hashes = map { $_->{norm_hash} } @$phrases;
        my @ids = map { $_->{id} } @$phrases;
        $log->out("update");
        relaxed times => 1, sub {
            do_sql(PPC(shard => $shard), ["update mcb_phrases set norm_hash = $id2hash_sql", where => {
                    norm_hash => \@old_hashes,
                    id => \@ids,
                }
            ]);
        };
        $min += $chunk;
    }
}

$log->out('ppcdict');

my $phrases = get_all_sql(PPCDICT, "select norm_phrase, norm_hash from mcb_theme_phrases");
$log->out($phrases);
my %norm2new = map { $_->{norm_hash} => get_phrase_props($_->{norm_phrase})->{norm_hash} } @$phrases;
my $norm2new_sql = sql_case(norm_hash => \%norm2new);
my @phrases = map { $_->{phrase} } @$phrases;

do_sql(PPCDICT, ["update mcb_theme_phrases set norm_hash = $norm2new_sql", where => { norm_phrase => \@phrases }]);


$log->out('FINISH');

