#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "2 часа на devtest",
  comment => "Переотправляем в БК все объявления с визиткой, в которой указан только город (11.5 млн. баннеров)"
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use ShardingTools qw/ppc_shards/;
use Yandex::Retry qw/relaxed/;

use utf8;

$log->out('START');

my $CHUNK = 500_000;
my $resend_cnt = 0;
for my $shard (ppc_shards()) {
    $log->msg_prefix("[$shard]");
    my ($min, $max) = get_one_line_array_sql(PPC_HEAVY(shard => $shard), "select min(vcard_id), max(vcard_id) from vcards");
    $min //= 0;
    $max //= 0;
    while ($min < $max) {
        $log->out("select: $min .. $max");
        my $vcards = get_one_column_sql(PPC_HEAVY(shard => $shard), ["
            select vcard_id from vcards",
            where => {
                vcard_id__between => [ $min, $min + $CHUNK - 1],
                geo_id__gt => 0,
                street__is => '',
                house__is  => '',
                build__is  => '',
                apart__is  => '',
            }
        ]) || [];
        $log->out(sprintf "$min: %d vcards", scalar @$vcards);
        my $cnt = int relaxed times => 1, sub {
            do_sql(PPC(shard => $shard), ["
                insert ignore into bs_resync_queue (cid,bid,priority)
                select b.cid, b.bid, -100
                from banners b
                join vcards vc on vc.vcard_id = b.vcard_id",
                where => {
                    'vc.vcard_id' => $vcards,
                    'b.phoneflag' => 'Yes',
                    'b.statusShow' => 'Yes',
                    'b.statusArch' => 'No',
                    'b.BannerID__gt' => 0,
                }
            ]);
        };
        $log->out("resend $cnt banners");
        $resend_cnt += $cnt;
        $min += $CHUNK;
    }

}
$log->msg_prefix('');
$log->out("total $resend_cnt to resend");


$log->out('FINISH');

