#!/usr/bin/perl -w

use my_inc "..";

=head1 DEPLOY

# approved by mirage
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "5 секунд",
  comment => "Скрипт устанавливает/сбрасывает параметры для торможения запросов к АПИ от клиентов:
Для установки запускаем скрипт с опцией --action=set:
./deploy/20140514_fill_client_api_options.pl --action=set

Для сброса установленных значений (потребуется примерно через сутки после установки):
./deploy/20140514_fill_client_api_options.pl --action=reset"
}

=cut

=pod
 
=head1 DESCRIPTION

    По списку в теле скрипта, устаналивает специальные параметры клиентам ( список взят из DIRECT-31501 )

=head1 SYNOPSYS

    Для установки параметров:
        ./deploy/20140514_fill_client_api_options.pl --action=set

    Для сброса параметров тем же клиентам:
        ./deploy/20140514_fill_client_api_options.pl --action=reset

=cut

use warnings;
use strict;
use utf8;

use lib::abs '../protected';

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use Primitives qw//;

my $ACTION;
GetOptions(
    "action=s" => \$ACTION,
);

die "Need specify param --action=set|reset" unless $ACTION;

$log->out('START');

my $data = get_special_options();

if ($ACTION eq 'set' || $ACTION eq 'reset') {
    
    while (my ($client_id, $options) = each %$data) {
        
        next unless $client_id && defined $options;
        
        foreach my $keyname (keys %$options) {
            my $value = $ACTION eq 'set' ? $options->{$keyname} : "";
            
            Primitives::set_special_user_option($client_id, $keyname, $value);
            
            $log->out({client_id => $client_id, keyname => $keyname, value => $value});
        }
    }

} else {

    die "Need specify param --action=set|reset";
}

$log->out('END.');

sub get_special_options
{
    my $options = {};
    
    while (my $row = <DATA>) {
        $row =~ s/[\n\r]+//gsi;
        
        my ($ClientID, $sleep_min_time, $sleep_max_time, $sleep_start_time, $sleep_end_time, $sleep_probability) = split /;/, $row, 6;
        
        die "Dont specified option: row=$row" unless $ClientID && scalar( grep {defined $_} ($sleep_min_time, $sleep_max_time, $sleep_start_time, $sleep_end_time, $sleep_probability) ) == 5;
        
        $options->{$ClientID} = {
            sleep_min_time_calls_limit => $sleep_min_time
            , sleep_max_time_calls_limit => $sleep_max_time
            , sleep_start_time_calls_limit => $sleep_start_time
            , sleep_end_time_calls_limit => $sleep_end_time
            , sleep_probability_calls_limit => $sleep_probability
        };
    }
    
    return $options;
}

__DATA__
3249161;13000;23000;2;12;936
1133197;13000;23000;2;12;995
1570828;13000;23000;2;12;964
975458;13000;23000;2;12;982
4176112;13000;23000;2;12;984
1225163;13000;23000;2;12;990
2032216;13000;23000;2;12;989
2406341;13000;23000;2;12;987
2079189;13000;23000;2;12;988
1641912;13000;23000;2;12;978
1954573;13000;23000;2;12;994
2101993;13000;23000;2;12;986
1896574;13000;23000;2;12;993
534194;13000;23000;2;12;993
411859;13000;23000;2;12;995
334782;13000;23000;2;12;995
457695;13000;23000;2;12;995
2557558;13000;23000;2;12;995
473737;13000;23000;2;12;991
823590;13000;23000;2;12;996
4043278;13000;23000;2;12;993
2086717;13000;23000;2;12;999
1534398;13000;23000;2;12;997
2444755;13000;23000;2;12;995
543049;13000;23000;2;12;999
3322050;13000;23000;2;12;997
385619;13000;23000;2;12;997
443220;13000;23000;2;12;998
2566855;13000;23000;2;12;998
2232083;13000;23000;2;12;998
2379788;13000;23000;2;12;999
4078346;13000;23000;2;12;999
3494151;13000;23000;2;12;999
3985646;13000;23000;2;12;999
3048331;13000;23000;2;12;1000
