#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "5-10 секунд на дев7",
  comment => "Останавливаем включенные заархивированные кампании"
}

=cut

use strict;
use warnings;
use utf8;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::ListUtils;

use my_inc "..";

use Settings;
use ScriptHelper;
use ShardingTools;

# сколько кампаний обновлять за 1 раз
use constant UPDATE_CHUNK_SIZE => 200;

$log->out('START');

for my $shard (ppc_shards()) {
    $log->msg_prefix("shard $shard:");
    $log->out('Fetching camps list');
    my $camps = get_one_column_sql(PPC(shard => $shard), 'SELECT cid FROM campaigns WHERE archived = "Yes" AND statusShow = "Yes" AND type IN ("text", "mcb", "geo")');
    $log->out($camps);
    for my $chunk (chunks($camps, UPDATE_CHUNK_SIZE)) {
        $log->out({ "updating_camps_chunk" => $chunk });
        my $res = do_update_table(PPC(shard => $shard), 'campaigns', { statusShow => "No", statusBsSynced => "No" }, where => {
            archived        => "Yes",
            statusShow      => "Yes",
            cid             => $chunk,
        });
        $log->out("Updated $res rows");
    }
}
$log->msg_prefix(undef);

$log->out('FINISH');

