#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by mirage
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "несколько минут (возможно 10 - 15)",
  comment => "Удаляем у баннеров ошибочные vcard_id, появившиеся из-за бага в копировании кампаний"
}

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::ListUtils;
use Yandex::Retry;

use Settings;
use ScriptHelper;
use ShardingTools qw/ppc_shards/;

use constant START_CID => 9335325;

$log->out('START');

foreach my $shard (ppc_shards()) {
    $log->msg_prefix("shard $shard:");
    $log->out("Fetching cids of copied campaigns from 2014-05-27 14:00:00");
    my $cids = get_one_column_sql(PPC(shard => $shard), ['SELECT cid FROM campaigns', WHERE => {cid__gt => START_CID, copiedFrom__gt => 0}] );
    $log->out({copied_camps => $cids});

    my $banners_cnt = 0;
    my $fixed_cnt = 0;

    for my $cids_chunk (chunks($cids, 50)) {
        $log->out('Fetching banners chunk with bad vcard_id value');
        my $banners = get_all_sql(PPC(shard => $shard), [
            'SELECT b.bid, b.vcard_id
               FROM banners b
                    LEFT JOIN vcards v ON v.vcard_id = b.vcard_id AND v.cid = b.cid',
              WHERE => {
                'b.cid' => $cids_chunk,
                'b.vcard_id__is_not_null' => 1,
                'v.vcard_id__is_null' => 1,
            },
        ]);
        $banners_cnt += scalar @$banners;

        for my $banners_chunk (chunks($banners, 1_000)) {
            $log->out({banners_chunk_to_fix => $banners_chunk});
            relaxed times => 5, sub {
                local $Yandex::DBTools::QUERIES_LOG = 'sql';
                my $res = do_sql(PPC(shard => $shard), [
                    "UPDATE banners b
                            LEFT JOIN vcards v ON v.vcard_id = b.vcard_id AND v.cid = b.cid
                        SET b.vcard_id = NULL, b.statusBsSynced = 'No', b.phoneflag = 'New'",
                      WHERE => {
                        'b.bid' => [map { $_->{bid} } @$banners_chunk],
                        'b.vcard_id__is_not_null' => 1,
                        'v.vcard_id__is_null' => 1,
                    }
                ]);
                $log->out("Updated " . (0+$res) . " rows");
                $fixed_cnt += scalar @$banners_chunk;
            };
        }
    }
    $log->out("Banners count with bad vcard_id: $banners_cnt\tfixed count: $fixed_cnt");
}
$log->msg_prefix(undef);

$log->out('FINISH');

