#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by pankovpv 
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "1 минута",
  comment => qq{
    Вызов скрипта: /var/www/ppc.yandex.ru/deploy/20140616_fix_nonptinting_chars.pl
    Удаляем не печатываемые символы из номеров телефона
    Будет обновлено ~ 720 телефонов
  }
}

=cut

use strict;
use warnings;
use utf8;
use Yandex::DBTools;
use Yandex::DBShards;
use Settings;
use ScriptHelper; 
use ShardingTools;

$log->out('start');
foreach_shard_parallel shard => [ppc_shards()], sub {
    my $shard = shift;

    $log->msg_prefix("shard $shard: ");
    my $phones = get_all_sql(PPC(shard => $shard), 'SELECT phone, uid FROM users WHERE phone IS NOT NULL');
    foreach my $phone (@$phones) {
        if ($phone->{phone} =~ /[^[:print:]]/) {
            my $new_phone = $phone->{phone} =~ s/[^[:print:]]//gr;
            my $affected = do_sql(PPC(shard => $shard), "UPDATE users SET phone = ? WHERE uid = ? AND phone = ?", $new_phone, $phone->{uid}, $phone->{phone});
            if ($affected + 0) {
                $log->out(sprintf "phone %s for uid %d updated to %s", $phone->{phone}, $phone->{uid}, $new_phone);
            }
        }
    }
};
$log->out('finish');
