#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "90 минут",
  comment => "нормализуем поле banners.flags - удаляем мусор и пересортировываем
При падении скрипт можно перезапускать, поддерживается параметр --sleep-coef"
}

=cut

use warnings;
use strict;
use utf8;

use Memoize;
use List::Util qw/max/;
use List::MoreUtils qw/uniq/;

use Yandex::DBTools;
use Yandex::Retry;
use Yandex::ListUtils;

use Settings;
use ScriptHelper;

use ShardingTools;
use BannerFlags;

memoize('refine_flags');

my (@SHARDS, $START_BID, $STOP_BID);
my $STEP = 1_000_000;
my $SLEEP_COEF = 0.1;
extract_script_params(
    'shard-id:i' => \@SHARDS,
    'start:i' => \$START_BID,
    'stop:i' => \$STOP_BID,
    'step:i' => \$STEP,
    'sleep-coef' => \$SLEEP_COEF,
    );

$log->out("START");

@SHARDS = ppc_shards() if !@SHARDS;
$START_BID //= 0;
$STOP_BID //= max @{get_one_column_sql(PPC(shard => 'all'), "SELECT max(bid) FROM banners")};

for(my $start = $START_BID; $start < $STOP_BID; $start += $STEP) {
    for my $shard (@SHARDS) {
        $log->out("shard: $shard, start: $start");
        relaxed times => $SLEEP_COEF, sub {

            my $sth = exec_sql(PPC(shard => $shard), "SELECT bid, flags FROM banners WHERE bid >= ? AND bid < ? AND ifnull(flags, '') != ''", $start, $start + $STEP);
            my %flags_change;
            while(my ($bid, $flags) = $sth->fetchrow_array) {
                my $new_flags = refine_flags($flags);
                next if $flags eq $new_flags;
                $log->out(" fix for bid=$bid: '$flags' -> '$new_flags'");
                push @{$flags_change{$flags}{$new_flags}}, $bid;
            }

            while(my ($flags, $h) = each %flags_change) {
                while(my ($new_flags, $bids) = each %$h) {
                    my $rows = 0;
                    for my $bids_chunk (chunks $bids, 1_000) {
                        $rows += do_update_table(PPC(shard => $shard), 'banners', {flags => $new_flags, LastChange__dont_quote => 'LastChange'}, where => {bid => $bids_chunk, flags => $flags});
                    }
                    $log->out(" updated $rows rows: $flags -> $new_flags");
                }
            }
        };
    }
}

$log->out('FINISH');

sub refine_flags {
    my ($flags) = @_;
    return join ',', sort uniq grep {BannerFlags::is_valid_banner_flag($_)} split /\s*,\s*/, $flags;
}
