#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "2 часа",
  comment => "скрипт можно перезапускать, поддерживает --sleep-coef"
}

=cut

use warnings;
use strict;
use utf8;

use List::Util qw/max/;

use Yandex::DBTools;
use Yandex::Retry;
use Yandex::ListUtils qw/chunks/;

use Settings;
use ScriptHelper;
use ShardingTools;

$log->out('START');

my (@SHARDS, $START_BID, $STOP_BID);
my $STEP = 1_000_000;
my $SLEEP_COEF = 2;
extract_script_params(
    'shard-id:i' => \@SHARDS,
    'start:i' => \$START_BID,
    'stop:i' => \$STOP_BID,
    'step:i' => \$STEP,
    'sleep-coef' => \$SLEEP_COEF,
    );

$log->out("START");

@SHARDS = ppc_shards() if !@SHARDS;
$START_BID //= 0;
$STOP_BID //= max @{get_one_column_sql(PPC(shard => 'all'), "SELECT max(bid) FROM banners")};

for(my $start = $START_BID; $start < $STOP_BID; $start += $STEP) {
    for my $shard (@SHARDS) {
        $log->out("shard: $shard, start: $start");
        my $sth = exec_sql(PPC(shard => $shard), "SELECT bid, title, body FROM banners WHERE bid >= ? AND bid < ? AND (title rlike '&(quot|lt|gt|amp);' or body rlike '&(quot|lt|gt|amp);')", $start, $start + $STEP);
        my @bids;
        while(my ($bid, $title, $body) = $sth->fetchrow_array) {
            $log->out(" fix for bid=$bid: '$title', '$body'");
            push @bids, $bid;
        };
        for my $bids_chunk (chunks \@bids, 1000) {
            relaxed times => $SLEEP_COEF, sub {
                do_update_table(PPC(shard => $shard), 'banners', {
                    LastChange__dont_quote => 'LastChange',
                    title__dont_quote => q!replace(replace(replace(replace(title, '&quot;', '"'), '&gt;', '>'), '&lt;', '<'), '&amp;', '&')!,
                    body__dont_quote => q!replace(replace(replace(replace(body, '&quot;', '"'), '&gt;', '>'), '&lt;', '<'), '&amp;', '&')!,
                                }, 
                                where => {bid => $bids_chunk});
            };
        }
    }
}

$log->out('FINISH');

