#!/usr/bin/perl

use my_inc "..";

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "1 sec",
  comment => "При загрузке через xls в кампании появились пустые группы"
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use ScriptHelper;
use Data::Dumper;

use utf8;
my $TARGET_CID = 9012637;
# select p.pid, b.bid from phrases p left join bids b using(pid) where p.cid = 9012637 and p.bid is null

$log->out('START');

    my $empty_groups = get_one_column_sql(PPC(cid => $TARGET_CID),
        [ "select p.pid from phrases p left join banners b using(pid)", where =>  {'p.cid' => SHARD_IDS, 'p.pid__lt' => 338592392, 'b.bid__is_null' => 1} ]);

    $log->out('Empty groups list');
    $log->out($empty_groups);

    my $deleted_groups = do_delete_from_table(PPC(pid => $empty_groups), 'phrases', where=>{pid => SHARD_IDS});

    $log->out('Deleted groups count');
    $log->out($deleted_groups);

$log->out('FINISH');

