#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "на devtest около 4 часов",
  comment => 'Удаляет записи из ppc.bs_order_target_stat для OrderID не из данного шарда.
              Если будут сильно отставать реплики - можно запустить с опцией --sleep-coef=3 (по умолчанию 1)'
}

=cut

use strict;
use warnings;
use utf8;

use my_inc "..";

use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Retry qw/relaxed/;
use ScriptHelper;
use ShardingTools;
use DBStat;

my $SLEEP = 1;
extract_script_params(
    'sleep-coef=i' => \$SLEEP,
) or die "can't parse options";

$log->out('START');

my $SELECT_ORDERS_CHUNK = 10_000;

my ($oid_min, $oid_max) = get_one_line_array_sql(PPCORDSTAT, 'select min(OrderID), max(OrderID) from bs_order_target_stat') ;

# удаляем дублированную статистику из "неправильных" шардов
foreach (my $oid_from = $oid_min; $oid_from <= $oid_max; $oid_from += $SELECT_ORDERS_CHUNK) {
    my $oid_to = $oid_from + $SELECT_ORDERS_CHUNK;
    $log->out("check stat by shards for orders $oid_from .. $oid_to");
    foreach my $shard (ppc_shards()) {
        relaxed times => $SLEEP, sub {
            my $deleted = do_sql(PPC(shard => $shard), 'delete s from bs_order_target_stat s 
                                                            left join campaigns c using(OrderID) 
                                                                where c.OrderID is null and s.OrderID between ? and ?',
                                                                      $oid_from, $oid_to);
            $deleted += 0;
            $log->out("shard_$shard: deleted $deleted items");
        };
    }
}

$log->out('FINISHED');
