#!/usr/bin/perl

use my_inc "..";

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "10 min",
  comment => "Эксперимент с местом отображения ставок закончен. Запуск скрипта: /var/www/ppc.yandex.ru/deploy/20140731_bid_experiment_off.pl"
}

=cut

use strict;
use warnings;

use Settings;
use ScriptHelper;
use YAML;
use Yandex::Retry;
use Yandex::DateTime;

use User;
use Yandex::DBTools;
use Yandex::DBShards;
use Data::Dumper;

use utf8;
$log->out('START');

my $USERS_OPTIONS_TABLE_NAME = 'users_options';

my $clids = get_one_column_sql(PPCDICT, ["select clientid from bid_experiment", where => {slot__le => 10}]);
my $users_options = get_hash_sql( PPC(ClientID => $clids), [
        "select u.uid, uo.options from users u join $USERS_OPTIONS_TABLE_NAME uo using(uid)",
        where => {'u.ClientID' => SHARD_IDS}
]);

my $uids = [keys %$users_options];
$log->out(sprintf "UIDS FOR UPDATE: %s", scalar(@$uids));
my $updated = 0;
for my $chunk (sharded_chunks uid => $uids, chunk_size => 10000) {
    $log->out("next chunk with 10000 rows");
    my $statement = "update $USERS_OPTIONS_TABLE_NAME set options = case uid ";
    for my $uid(@{$chunk->{uid}}){
        my $old_options = $users_options->{$uid};
        my $option = User::parse_user_options($old_options);
        $option->{horizontal_prices} = 1;
        my $new_options = YAML::Dump($option);
        $old_options ||= "FAKE NULL";

        $old_options = sql_quote($old_options);
        $new_options = sql_quote($new_options);
        $statement .= " when $uid then if(options is null or options = '', $new_options, if(options = $old_options, $new_options, options))"
    }

    $statement .= ' end';
    my $current_updated;
    relaxed times => 3, sub{
        $current_updated += do_sql(PPC(shard => $chunk->{shard}), [$statement, where => {uid => $chunk->{uid}}]);
    };
    $updated += $current_updated;
    if(@{$chunk->{uid}} != $current_updated){
        my $message = sprintf("for update: %s, but updated: %s",scalar(@{$chunk->{uid}}), $current_updated);
        $log->out($message);
    }
}
$log->out("UPDATED UIDS: $updated");

$log->out('FINISH');
