#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "4 часа",
  comment => "восстанавливает корректные значения в sitelinks_sets.hash"
}

=cut

use warnings;
use strict;
use utf8;

use List::Util qw/max/;

use Yandex::DBTools;
use Yandex::Retry;

use Settings;
use ScriptHelper;
use ShardingTools;

$log->out('START');

my $chunk_size = 10_000;

my $max_id = max @{get_one_column_sql(PPC(shard => 'all'), "SELECT max(sitelinks_set_id) FROM sitelinks_sets")};
for(my $start = 0; $start <= $max_id; $start += $chunk_size) {
    for my $shard (ppc_shards()) {
        $log->out("shard: $shard, start: $start");
        relaxed times => 1, sub {
            # апдейтим всё и таким образом, чтобы реплики стали консистентными
            do_sql(PPC(shard => $shard), "
                        INSERT INTO sitelinks_sets (sitelinks_set_id, ClientID, hash, links_hash)
                             SELECT ss.sitelinks_set_id, ss.ClientID, group_concat(sl.sl_id order by order_num) as hash, 0 as links_hash
                               FROM sitelinks_sets ss
                                    JOIN sitelinks_set_to_link sstl USING (sitelinks_set_id)
                                    JOIN sitelinks_links sl USING (sl_id)
                              WHERE ss.sitelinks_set_id between ? and ? 
                              GROUP BY ss.sitelinks_set_id
                        ON DUPLICATE KEY UPDATE hash = values(hash)
                        ", $start, $start + $chunk_size - 1);
        };
    }
}

$log->out('FINISH');

