#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "4 часа",
  comment => "рассчитываем корректные значения в sitelinks_sets.links_hash по hash"
}

=cut

use warnings;
use strict;
use utf8;

use List::Util qw/max/;

use Yandex::DBTools;
use Yandex::Retry;

use Settings;
use ScriptHelper;
use ShardingTools;

$log->out('START');

my $chunk_size = 10_000;

my $max_id = max @{get_one_column_sql(PPC(shard => 'all'), "SELECT max(sitelinks_set_id) FROM sitelinks_sets")};
for(my $start = 0; $start <= $max_id; $start += $chunk_size) {
    for my $shard (ppc_shards()) {
        $log->out("shard: $shard, start: $start");
        relaxed times => 1, sub {
            # апдейтим всё и таким образом, чтобы реплики стали консистентными
            do_update_table(PPC(shard => $shard), "sitelinks_sets",
                            {
                                links_hash__dont_quote => 'conv( substr( md5(hash), 1, 16 ), 16, 10 )',
                            }, where => {
                                sitelinks_set_id__between => [$start, $start + $chunk_size - 1],
                                links_hash => 0
                            }
                );
        };
    }
}

$log->out('FINISH');

