#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "6 часов",
  comment => "проставляем banners.opts.geoflag по banners.geoflag, миграцию можно перезапускать"
}

=cut

use warnings;
use strict;
use utf8;

use List::Util qw/max/;

use Yandex::ListUtils;
use Yandex::DBTools;
use Yandex::Retry;

use Settings;
use ScriptHelper;
use ShardingTools;

$log->out('START');

my $select_chunk_size = 100_000;
my $update_chunk_size = 1_000;

my $max_id = max @{get_one_column_sql(PPC(shard => 'all'), "SELECT max(bid) FROM banners")};
for(my $start = 0; $start <= $max_id; $start += $select_chunk_size) {
    for my $shard (ppc_shards()) {
        $log->out("shard: $shard, start: $start");
        my $bids = get_one_column_sql(PPC(shard => $shard), [
                                          "SELECT bid FROM banners", 
                                          WHERE => {
                                              _TEXT => 'find_in_set("geoflag", opts) xor IFNULL(geoflag, 0)',
                                              bid__between => [$start, $start + $select_chunk_size - 1],
                                          }
                                      ]);
        for my $chunk (chunks $bids, $update_chunk_size) {
            $log->out("bids for update: ", $chunk);
            relaxed times => 1, sub {
                do_update_table(PPC(shard => $shard), "banners",
                                {
                                    opts__dont_quote => 'IF(geoflag, concat(opts, ",", "geoflag"), replace(concat(",", opts, ","), ",geoflag,", ","))',
                                    LastChange__dont_quote => 'LastChange',
                                }, where => {
                                    bid => $chunk,
                                    _TEXT => 'find_in_set("geoflag", opts) xor IFNULL(geoflag, 0)'
                                }
                    );
            };
        };
    }
}

$log->out('FINISH');

