#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'секунда-другая',
  comment => 'Переносим данные из PPCORDSTAT.currency_converted_orders в PPC.currency_converted_orders'
}

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::DBShards;

use Settings;
use ScriptHelper;

$log->out('START');

my $old_orderids = get_one_column_sql(PPCORDSTAT, 'SELECT OrderID FROM currency_converted_orders') || [];
$log->out('Copying OrderIDs:', $old_orderids);
foreach_shard OrderID => $old_orderids, sub {
    my ($shard, $orderids) = @_;

    $log->out("Inserting OrderIDs into shard $shard:", $orderids);
    my @to_insert = map { [$_] } $orderids;
    do_mass_insert_sql(PPC(shard => $shard), 'INSERT IGNORE INTO currency_converted_orders (OrderID) VALUES %s', \@to_insert);
};

$log->out('FINISH');
