#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '1 c',
  comment => 'Восстановление прав в RBAC на кампанию кошелек(cid == 9827542) для агенства(uid == 86563128)'
}

=cut

use warnings;
use strict;
use utf8;


use ScriptHelper;
use RBAC2::Extended;
use RBACDirect;

$log->out('START');

my $AgencyUID = 86563128;
my $client_chief_uid = 269134726;
my $wallet_cid = 9827542;

my $rbac = RBAC2::Extended->get_singleton($AgencyUID);
my $rbac_error = rbac_save_camp_for_agency($rbac, $AgencyUID, $client_chief_uid, $wallet_cid);

$log->out("rbac error: $rbac_error") if $rbac_error;
$log->out('FINISH');
