#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by mirage
# .migr
[
{
  type => 'script',
  when => 'after',
  time_estimate => "30 мин",
  comment => "выставляет событию money_in_wallet для кампании с общим счетом правильный type"
}
]
=cut

use strict;
use warnings;

use Settings;
use Yandex::DBTools;
use Yandex::Retry;
use ScriptHelper;
use Yandex::ListUtils qw/chunks/;

use utf8;

$log->out('START');
#получаем все кампании - общие счета
my $wallets = get_hash_sql(PPC(shard => 'all'), [
        "select cid from campaigns where type='wallet'",
    ]);
my $min_id = get_one_field_sql(MONITOR, "select id from eventlog where eventtime >= '2013-11-19 15:33:56' limit 1");
while (1) {
    my $chunk = get_all_sql(MONITOR,
            ["select id, cid from eventlog",
            where => {
                type => 3 ,
                id__gt => $min_id
            },
            "limit 1000"]);
    last unless @$chunk;
    
    $min_id = $chunk->[-1]->{id};
    $log->out("min_id $min_id");
    
    my @wallets_events = grep {exists $wallets->{$_->{cid}}} @$chunk;
    next unless @wallets_events;
    
    my @ids = map {$_->{id}} @wallets_events;
    relaxed times => 3, sub {
        do_update_table(MONITOR, 'eventlog', {type => 15},
            where => {id__in => \@ids}
        );
    };
    $log->out(join(',', @ids));
}

$log->out('FINISH');

