#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "3 часа",
  comment => "исправляем состояние данных в minus_words"
}

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::ListUtils;
use Yandex::HashUtils;
use Yandex::Retry;

use Settings;
use ScriptHelper;
use ShardingTools;
use MinusWords;
use BS::ResyncQueue;

$log->out('START');

for my $shard (ppc_shards()) {
    
    for my $tbl ('phrases', 'mediaplan_banners') {
 
        $log->out("shard: $shard, tbl: $tbl");
        my $id = $tbl eq 'phrases' ? 'pid' : 'mbid';

        # получаем некорректные данные
        my $rows = get_all_sql(PPC_HEAVY(shard => $shard), "
                SELECT STRAIGHT_JOIN t.$id, t.cid, t.mw_id, u.ClientID
                  FROM $tbl t
                       LEFT JOIN minus_words mw on mw.mw_id = t.mw_id
                       JOIN campaigns c on c.cid = t.cid
                       JOIN users u on u.uid = c.uid
                 WHERE t.mw_id > 0
                   AND u.ClientID > 0
                   AND (mw.ClientID != u.ClientID OR mw.mw_id is null)
                ");

        $log->out("selected ".scalar(keys @$rows)." incorrect rows");
    
        # группируем по mw_id / ClientID
        my %mw2client2ids;
        for my $row (@$rows) {
            push @{$mw2client2ids{$row->{mw_id}}{$row->{ClientID}}}, hash_cut $row, 'cid', $id;
        }
        
        # получаем текты всех минус-слов (ищем по всем шардам)
        my %mw_texts;
        for my $mw_ids_chunk (chunks [nsort keys %mw2client2ids], 1000) {
            hash_merge \%mw_texts, get_hash_sql(PPC(shard => 'all'), ["SELECT mw_id, mw_text FROM minus_words", WHERE => {mw_id => $mw_ids_chunk}]);
        }
    
        while(my ($mw_id, $client2ids) = each %mw2client2ids) {
            while(my ($ClientID, $cids_ids) = each %$client2ids) {
                relaxed times => 3, sub {
                    my $new_mw_id;
                    if (defined $mw_texts{$mw_id}) {
                        $new_mw_id = MinusWords::save_minus_words($mw_texts{$mw_id}, $ClientID);
                    };
                    for my $chunk (chunks $cids_ids, 1_000) {
                        my @pk_ids = map {$_->{$id}} @$chunk;
                        $log->out({ClientID => $ClientID, mw_id => $mw_id, new_mw_id => $new_mw_id, tbl => $tbl, ids => \@pk_ids});
                        
                        do_in_transaction {
                            if ($tbl eq 'phrases') {
                                BS::ResyncQueue::bs_resync([map {hash_merge {priority => -26}, $_} @$chunk]);
                            }
                            do_update_table(PPC(shard => $shard), $tbl,
                                            {mw_id => $new_mw_id},
                                            where => {$id => \@pk_ids, mw_id => $mw_id}
                                );
                        };
                    };
                };
            }
        }
    }
}

$log->out('FINISH');

