#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by mirage
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '10s',
  comment => 'Только для песочницы. Удалить недоудалённых пользователей'
}

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::DBShards;
use ScriptHelper;
use RBAC2::Extended;
use RBACDirect;
use RBACElementary;
use Settings;
use EnvTools qw/is_sandbox/;
use List::MoreUtils qw/uniq/;
use VCards;
use Tag;
use PrimitivesIds;

$log->out('START');

unless (is_sandbox()) {
    $log->out('not a sandbox');
    die "wrong configuration";
}

my $camps = get_hash_sql(PPC(shard => 1), "select cid, c.uid from campaigns c left join users u using(uid) where u.uid is null");
my $rbac = RBAC2::Extended->get_singleton(1);
my $uids = [uniq values %$camps];
my %cids_by_uid;
while (my ($cid, $uid) = each(%$camps)) {
    push(@{$cids_by_uid{$uid}}, $cid);
}

my $roles = rbac_multi_who_is($rbac, $uids);
my $cl_ids = rbac_get_client_clientids_by_uids($uids);

$log->out("Deleting campaigns from rbac");
foreach my $cid (keys %$camps) {
    unless ($cl_ids->{$camps->{$cid}}) {
        $log->out("no client_id (uid: $camps->{$cid})");
        next;
    }
    eval {
        my $error = rbac_delete_campaign($rbac, $cid, $camps->{$cid});
        if ($error) {
            $log->out("rbac error on delete campaign (cid: $cid, uid: $camps->{$cid}, code: $error)");
        }
    };
    if( $@ ) {
        $log->out("rbac error on delete campaign (cid: $cid, uid: $camps->{$cid}, error: $@)");
    }
}

$log->out("Desyncing campaigns");
do_update_table(PPC(shard => 1), 'campaigns', {sum => 0, sum_to_pay => 0, sum_last => 0, OrderID => 0, statusBsSynced => 'No'}, where => {cid => [keys %$camps]});

$log->out("Unbinding subclients");
foreach my $uid (@$uids) {
    next if $roles->{$uid} eq 'agency';
    eval {
        if (my $agencies = rbac_get_agencies_of_client($rbac, $uid)) {
            my $auid = $agencies->[0];
            if (defined $auid) {
                if (rbac_unbind_agency($rbac, $auid, $uid)) {
                    $log->out("rbac error on unbind client from agency in rbac (uid: $uid)");
                }
            }
        }
    };
    if( $@ ) {
        $log->out("rbac error on unbind client from agency in rbac (uid: $uid), error: $@)");
    }
}

$log->out("Deleting clients and their campaigns");
foreach my $uid (@$uids) {
    if ($cl_ids->{$uid}) {
        my $errcode = $rbac->Handle('RBAC_DropClient', {client_id => $cl_ids->{$uid}});
        if ($errcode) {
            $log->out("rbac error on drop client (uid: $uid)");
        }
        $rbac->Commit;
    }

    foreach my $cid (@{$cids_by_uid{$uid}}) {
        my_del_camp_data($cid, $uid);
    }
}

$log->out('FINISH');

sub my_del_camp_data { # копия &Campaign::del_camp_data для текстовых кампаний, не проверяющая возможность удалить (она падает без записи в ppc.users)
    my ($cid, $uid) = @_;

    my $vcards_to_delete = get_one_column_sql(PPC(cid => $cid), 'SELECT DISTINCT vcard_id FROM vcards WHERE cid = ?', $cid) || [];

    # удаляем визитки вместе с адресами.
    VCards::delete_vcard_from_db($vcards_to_delete, skip_org_details => 1);

    my @delete_by_cid = qw/campaigns camp_options user_campaigns_favorite camp_metrika_counters metrika_counters camp_marked_phones/;
    for my $table (@delete_by_cid) {
        do_delete_from_table(PPC(cid => $cid), $table, where => { cid => $cid });
    }

    # Удаляем метки;
    Tag::delete_campaign_tags($cid);

    my $pids = get_pids(cid => $cid);
    my $bids = get_bids(cid => $cid);
    my $mbids = get_one_column_sql(PPC(cid => $cid), "select mbid from mediaplan_banners where cid = ?", $cid);

    my $now = Yandex::DateTime->now();
    do_mass_insert_sql(PPC(cid => $cid), "REPLACE INTO deleted_banners (bid, deleteTime) VALUES %s",
                       [map {[$_, $now]} @$bids]);

    do_delete_from_table(PPC(cid => $cid), 'banner_images', where => {bid => $bids}) if @$bids;
    do_delete_from_table(PPC(cid => $cid), 'banners', where => {cid=>$cid});
    do_sql(PPC(cid => $cid), qq!
            DELETE bhp
              FROM bids bi join bids_href_params bhp using (id)
             WHERE bi.cid = ?
        !, $cid);
    do_delete_from_table(PPC(cid => $cid), 'bids', where => {cid=>$cid});
    do_delete_from_table(PPC(cid => $cid), 'bids_manual_prices', where => {cid=>$cid});
    do_delete_from_table(PPC(cid => $cid), 'bids_arc', where => {cid=>$cid});
    do_delete_from_table(PPC(cid => $cid), "bids_retargeting", where => {pid => $pids});

    do_delete_from_table(PPC(cid => $cid), 'group_params', where => {pid => $pids});
    do_delete_from_table(PPC(cid => $cid), 'phrases', where => {cid => $cid});

    do_delete_from_table(PPC(cid => $cid), 'mediaplan_bids_retargeting', where => {mbid => $mbids}) if @$mbids;
    do_delete_from_table(PPC(cid => $cid), 'mediaplan_banners', where => {cid=>$cid});
    do_delete_from_table(PPC(cid => $cid), 'mediaplan_bids', where => {cid=>$cid});
    do_delete_from_table(PPC(cid => $cid), 'mediaplan_banners_original', where => {cid=>$cid});
    do_delete_from_table(PPC(cid => $cid), 'redirect_check_queue', where => {object_id => $bids, object_type => 'banner'}) if @$bids;
    do_delete_from_table(PPC(cid => $cid), 'autobudget_forecast', where => {cid => $cid});

    do_delete_from_table(PPC(cid => $cid), 'mod_reasons', where => { id => $bids, type => [qw/banner contactinfo sitelinks_set image/]});
    do_delete_from_table(PPC(cid => $cid), 'mod_reasons', where => { id => $pids, type => [qw/phrases/]});
    do_delete_from_table(PPC(cid => $cid), 'mod_reasons', where => { id => $cid, type => [qw/campaign/]});

    delete_shard(bid => $bids);
    delete_shard(pid => $pids);
    delete_shard(mediaplan_bid => $mbids) if @$mbids;

    if ($uid) {
        OrgDetails::clean_org_details(uid => $uid);
    }

    delete_shard(cid => $cid);

    return 1;
}