#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
[
  {
    type => 'sql',
    webstop => "0",
    db => "ppc:all",
    when => 'before',
    time_estimate => "3 минуты",
    comment => "заблокироваться должно небольшое количество запросов (10-30), перед выполнением в продакшене просьба предупредить zhur",
    sql => [
        "DELETE FROM crm_queue WHERE status = 'Send' AND send_time < now() - interval 1 hour",
        "ALTER TABLE crm_queue ADD COLUMN params_json_compressed MEDIUMBLOB"
        ]
  },
  {
    type => 'script',
    when => 'after',
    time_estimate => "1 минута",
    comment => "высчитываем crm_queue.params_json_compressed по params_json"
  }
]

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::Retry;

use Settings;
use ScriptHelper;
use ShardingTools;

my $LIMIT = 1000;

$log->out('START');

for my $shard (ppc_shards()) {
    my $start_id = 0;
    while(1) {
        my $ids = get_one_column_sql(PPC(shard => $shard), "SELECT id FROM crm_queue WHERE id > ? ORDER BY id LIMIT $LIMIT", $start_id);
        last if !@$ids;
        relaxed times => 2, sub {
            $log->out({shard => $shard, min_id => $ids->[0], max_id => $ids->[-1]});
            do_update_table(PPC(shard => $shard), 
                            'crm_queue',
                            {params_json_compressed__dont_quote => 'compress(params_json)'}, 
                            where => {id__between => [$ids->[0], $ids->[-1]]}
                );
        };
        last if @$ids < $LIMIT;
        $start_id = $ids->[-1];
    }
}

$log->out('FINISH');

