#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by mirage
# .migr
[
  {
    type => 'sql',
    webstop => "0",
    db => "ppcdict",
    when => 'before',
    time_estimate => "1 секундa",
    sql => ["CREATE TABLE api_app_certification_request (
        `cr_id`             int(10) unsigned NOT NULL PRIMARY KEY,
        `application_id`    char(32)NOT NULL,
        `name`              varchar(500) NOT NULL,
        `uid`               bigint(20) unsigned NOT NULL,
        `access_type`       ENUM('test', 'normal', 'advanced') NOT NULL DEFAULT 'test',
        `request_info`      text NOT NULL,
        `other_info`        text,
        `create_time`       timestamp NOT NULL DEFAULT NOW(),
        `end_time`          timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
        `status`            ENUM('Approve', 'Reject', 'New') NOT NULL DEFAULT 'New',
        `check_time`        timestamp DEFAULT '0000-00-00 00:00:00',
        `comment`           text,
        UNIQUE `i_uid_application_id` (`application_id`,`uid`),
        KEY `i_uid` (`uid`),
        KEY `i_application_id` (`application_id`),
        KEY `i_create_time` (`create_time`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8",
         
        "CREATE TABLE api_app_certification_request_history (
        `cr_id`             int(10) unsigned NOT NULL PRIMARY KEY,
        `application_id`    char(32)NOT NULL,
        `name`              varchar(500) NOT NULL,
        `uid`               bigint(20) unsigned NOT NULL,
        `access_type`       ENUM('test', 'normal', 'advanced') NOT NULL DEFAULT 'test',
        `request_info`      text NOT NULL,
        `other_info`        text,
        `create_time`       timestamp NOT NULL DEFAULT NOW(),
        `end_time`          timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
        `status`            ENUM('Approve', 'Reject', 'New') NOT NULL DEFAULT 'New',
        `check_time`        timestamp DEFAULT '0000-00-00 00:00:00',
        `comment`           text,
        KEY `i_uid` (`uid`),
        KEY `i_application_id` (`application_id`),
        KEY `i_create_time` (`create_time`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8",
        
        "CREATE TABLE `api_app_access` (
        `application_id`    char(32)NOT NULL,
        `access_type`       ENUM('test', 'normal', 'advanced') NOT NULL DEFAULT 'test',
        PRIMARY KEY (`application_id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8"
    
    ]
  },
  {
    type => 'script',
    when => 'after',
    time_estimate => "1 минута",
    comment => "переносим данные из таблиц api_app_certification_request и api_app_certification_request_history а базу "
  }
]

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Retry;
use ShardingTools;

use Settings;
use ScriptHelper;

$log->out('START');
my @fields = qw/cr_id application_id name uid access_type request_info other_info create_time end_time status check_time comment/;
my $fields_str = join(',', @fields);
do_in_transaction{
    relaxed times => 1, sub {
        do_insert_select_sql(PPC(shard=>'all'),
            "INSERT INTO api_app_certification_request ($fields_str) VALUES %s",
            "SELECT $fields_str FROM api_app_certification_request",
            dbw => PPCDICT,
        ); 
    };
    $log->out('api_app_certification_request done');
    relaxed times => 1, sub {
        do_insert_select_sql(PPC(shard=>'all'),
            "INSERT INTO api_app_certification_request_history ($fields_str) VALUES %s",
            "SELECT $fields_str FROM api_app_certification_request_history",
            dbw => PPCDICT,
        ); 
    };
    $log->out('api_app_certification_request_history done');
};
$log->out('FINISH');
