#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by hrustyashko
# .migr
[
  {
    type => 'script',
    when => 'after',
    time_estimate => "1 минута",
    comment => "перегенерируем таймзоны",
    script => "sudo -u ppc /var/www/ppc.yandex.ru/protected/mk_regions.pl --timezones --langs ru ua tr en"
  },
  {
    type => 'sql',
    webstop => "0",
    db => "ppcdict",
    when => 'after',
    time_estimate => "1 сек",
    comment => "удаляем ошибочную таймзону",
    sql => "delete from geo_timezones where timezone_id = 762",
  },
  {
    type => 'script',
    when => 'after',
    time_estimate => "5 сек",
    comment => "заменяем ошибочную таймзону в кампаниях и переотправляем в БК"
  }
]

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use ShardingTools;
use Settings;
use ScriptHelper;

my $BAD_TIMEZONE_ID = 762;  # Europe/Moscow | Украина, Новопокровка
my $GOOD_TIMEZONE_ID = 130; # Europe/Moscow | Москва

# --------------------------------------------------------------------
sub main {
    $log->out('START');

    for my $shard (ppc_shards()) {
        my $cids = get_one_column_sql(PPC(shard => $shard), "select cid from campaigns where timezone_id = ?", $BAD_TIMEZONE_ID);
        $log->out({shard => $shard, selected_cids => $cids});

        for my $cid (@$cids) {
            my $result = do_update_table(PPC(shard => $shard),
                                         'campaigns',
                                         {timezone_id => $GOOD_TIMEZONE_ID, statusBsSynced => "No", LastChange__dont_quote => 'NOW()'},
                                         where => {cid => $cid, timezone_id => $BAD_TIMEZONE_ID}
            );
            $log->out({cid => $cid, result => $result});
        }
    }

    $log->out('FINISH');
}

main();
