#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "2-3 сек",
  comment => "DIRECT-35243 чиним клиента Kartrade-spb в Балансе"
}

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;

use Settings;
use ScriptHelper;
use Yandex::Balance;
use Data::Dumper;

#### ppc:1
# +----------+----------+--------------+
# | uid      | ClientID | login        |
# +----------+----------+--------------+
# | 21644004 |   531454 | kartrade-spb |
# +----------+----------+--------------+
my $OPERATOR_UID = 1;
my $main_client_id = 531454;
my $main_client_uid = 21644004;
my $client_id = 432944;
my $response;

$log->out('START');

$log->out("balance_merge_clients($OPERATOR_UID, $main_client_id, $client_id)");
$response = balance_merge_clients($OPERATOR_UID, $main_client_id, $client_id);
$log->out("response: ".Dumper($response));

$log->out("balance_call('Balance.EditPassport', [$OPERATOR_UID, $main_client_uid, {ClientId => $main_client_id, IsMain => 1}], {write_log => 1})");
$response = Yandex::Balance::balance_call('Balance.EditPassport', [$OPERATOR_UID, $main_client_uid, {ClientId => $main_client_id, IsMain => 1}], {write_log => 1});
$log->out("response: ".Dumper($response));

$log->out('FINISH');

