#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "2-3 сек",
  comment => "PAYSUP-160238 чиним привязку объектов к клиентам после объединения клиентов"
}

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;

use Settings;
use ScriptHelper;
use Client;
use BalanceQueue;

my $OPERATOR_UID = 1;
my $BALANCE_QUEUE_PRIORITY = 13;
my $main_client_id = 1544720;
my @ClientIDs = ($main_client_id, 1748791);

$log->out('START');

# перепривязываем всех представителей и объекты клиентов на основного в балансе клиента (1544720), к которому привязаны в rbac все представители
$log->out('Client::set_main_client_id for clients: ' . join(',', @ClientIDs));
set_main_client_id(\@ClientIDs);

# перепосылаем заказы в баланс (для обновления их привязки к ClientID)
my $cids = get_one_column_sql(PPC(ClientID => \@ClientIDs), ['select c.cid 
															    from campaigns c 
															    join users u on c.uid = u.uid',
															   where => {'u.ClientID' => $main_client_id,
															   			 'c.statusEmpty' => 'No',
															   			 'c.statusModerate' => 'Yes'}]);
if (@$cids) {
	$log->out('resent cids to balance: ' . join(',', @$cids));
	BalanceQueue::add_to_balance_info_queue($OPERATOR_UID, 'cid' => $cids, $BALANCE_QUEUE_PRIORITY);
}

$log->out('FINISH');

