#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by hrustyashko
# .migr
[
  {
    type => 'sql',
    webstop => 1,
    db => "ppc:all",
    when => 'before',
    time_estimate => "15 sec",
    sql => "alter table clients_options add use_adgroups tinyint NOT NULL DEFAULT 0",
  },
  {
    type => 'script',
    when => 'after',
    time_estimate => "5 сек",
    comment => "переносим ppc.users_api_options.upload_adgroup_xls в ppc.clients_options.use_adgroups"
  }
]

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use ShardingTools;
use Settings;
use ScriptHelper;

# --------------------------------------------------------------------
sub main {
    $log->out('START');

    for my $shard (ppc_shards()) {
        my $client_ids = get_one_column_sql(PPC(shard => $shard)
                                            , "select distinct u.ClientID
                                               from users u
                                                 join users_api_options uao using(uid)
                                               where uao.upload_adgroup_xls = 'Yes'
                                              ");
        $log->out({shard => $shard, selected_clients => $client_ids});
        next unless @$client_ids;

        my $result = do_update_table(PPC(shard => $shard),
                                     'clients_options',
                                     {use_adgroups => 1},
                                     where => {ClientID => $client_ids}
        );
        $log->out({result => $result});
    }

    $log->out('FINISH');
}

main();
