#!/usr/bin/perl


=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "1 минута",
  comment => "DIRECT-36011 Удаление магаданского часового пояса"
}

=cut

use strict;
use warnings;
use utf8;
use my_inc '..';

use Yandex::DBTools;

use Settings;
use ScriptHelper;
use ShardingTools;


$log->out('START');

my $tz_magadan = get_one_field_sql(PPCDICT, 'SELECT timezone_id FROM geo_timezones WHERE timezone="Asia/Magadan"');
my $tz_vladivostok = get_one_field_sql(PPCDICT, 'SELECT timezone_id FROM geo_timezones WHERE timezone="Asia/Vladivostok"');
$log->out("Asia/Magadan ($tz_magadan) -> Asia/Vladivostok ($tz_vladivostok)");

$log->die("Migration already done")  if !$tz_magadan;

for my $shard (ppc_shards()) {
    my $cids = get_one_column_sql(PPC(shard=>$shard), 'SELECT cid FROM campaigns WHERE timezone_id=?', $tz_magadan);
    $log->out(sprintf "shard #$shard: %d campaigns to update", scalar @$cids);
    next if !@$cids;

    $log->out($cids);
    # кампаний максимум несколько сотен, поэтому на чанки не бьём
    do_update_table(PPC(shard=>$shard), campaigns => {timezone_id => $tz_vladivostok}, where => {cid => $cids});
}

$log->out("removing tz Asia/Magadan ($tz_magadan)");
do_delete_from_table(PPCDICT, 'geo_timezones', where => {timezone_id => $tz_magadan});

$log->out('FINISH');

