#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "2 минуты",
  comment => "можно перезапускать"
}

=cut

# цель скрипта - пропустить сквозь репликацию ничего не меняющие апдейты для
# починки консистенотности реплик по бывшим timstamp-полям, разошедшихся из-за смемы часового пояса

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::HashUtils;

use Settings;
use ScriptHelper;
use ShardingTools;

$log->out('START');

for my $shard (ppc_shards()) {
    $log->out("SHARD $shard");
    my $camps = get_all_sql(PPC(shard => $shard), "
                        SELECT c.cid, c.start_time, c.finish_time
                          FROM campaigns c 
                               JOIN camp_options co USING(cid) 
                         WHERE (c.start_time >= 20141025 or c.finish_time >= 20141025) and co.create_time <= 20141026");
    for my $camp (@$camps) {
        $log->out($camp);
        do_update_table(PPC(shard => $shard), 'campaigns', hash_cut($camp, 'start_time', 'finish_time'), where => $camp);
    }
}

$log->out('FINISH');

