#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr

{
  type => 'script',
  when => 'instructions',
  instructions => '
- запустить спустя минимум 30 минут после выкладки пакетов (дожидаемся завершения обновления статистики старым кодом);
- можно запускать повторно;
- если один из ppcstatов недоступен, можно запускать выборочно на наборе работающих хостов (--host ppcstat:5 --host ppcstat:6), а затем на проблемном;',
  time_estimate => "1-2 минуты",
  comment => "сбрасываем всю детальную статистику за период после 2014-11-01"
}

=cut

use strict;
use warnings;

use my_inc "..";

use Settings;
use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;
use ScriptHelper;

use DBStat;

use utf8;

my $BORDER_DATE = '2014-11-01'; # дата, начиная с которой статистика детализируется по DeviceType

my @ppcstat_hosts;
extract_script_params(
    'host=s@' => \@ppcstat_hosts,
) || exit(1);
if (!@ppcstat_hosts) {
    @ppcstat_hosts = sort DBStat->get_db_hosts("");
}

$log->out('START');
$log->out("Working on hosts:", \@ppcstat_hosts);

for my $ppcstat_host (@ppcstat_hosts) {
    $log->msg_prefix("[$ppcstat_host]");

    $log->out("start processing host");
    my $dbh_stat = connect_db( $ppcstat_host );

    my $oids = get_one_column_sql($dbh_stat, 'select OrderID
                                                from order_stat_info
                                               where statEnd >= ? AND (syncTime > ? or statTime > ?)',
                                                     $BORDER_DATE, $BORDER_DATE, $BORDER_DATE);
    for my $oids_chunk (chunks $oids, 1000) {
        $log->out("trying to update orders: " . join(',', @$oids_chunk));
        my $updated = do_sql($dbh_stat, [qq/
                    UPDATE order_stat_info
                       SET syncTime=LEAST(syncTime, ?)
                         , statTime=LEAST(statTime, ?)/,
                     WHERE => { OrderID => $oids_chunk}], $BORDER_DATE, $BORDER_DATE);
        $updated += 0;
        $log->out("updated $updated orders");
    }

    $log->out("finish processing host");

}

