#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '1 секунда',
  comment => 'Перетаскиваем запись в users из 5го шарда в 1й, чтобы сделать решардинг 1=>5 и воссоединить его размазанные кампании',
}

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::DBShards;

use Settings;
use ScriptHelper;

my $UID_TO_MOVE = 121036142;
my $CLIENT_ID = 2866130;
my $SHARD_FROM = 5;
my $SHARD_TO = 1;

$log->out('START');
$log->out("Moving row from users for UID = $UID_TO_MOVE from shard $SHARD_FROM to shard $SHARD_TO");

$log->out("Fetching data from shard $SHARD_FROM");
my $data = get_one_line_sql(PPC(shard => $SHARD_FROM), ['SELECT * FROM users', WHERE => {uid => $UID_TO_MOVE}]);
$log->out('Old data:', $data);
$log->die("No data found for uid $UID_TO_MOVE") unless $data && %$data;

$log->out("Inserting data to shard $SHARD_TO");
do_insert_into_table(PPC(shard => $SHARD_TO), 'users', $data);

$log->out("Removing row from shard $SHARD_FROM");
do_delete_from_table(PPC(shard => $SHARD_FROM), 'users', where => {uid => $UID_TO_MOVE});

$log->out("Changing ClientID for uid $UID_TO_MOVE to be $CLIENT_ID");
save_shard(uid => $UID_TO_MOVE, ClientID => $CLIENT_ID);

$log->out("Adding ClientID $CLIENT_ID to reshard queue to be resharded $SHARD_FROM => $SHARD_TO");
do_insert_into_table(PPCDICT, 'reshard_queue', {
    ClientID => $CLIENT_ID,
    status => 'new',
    old_shard => $SHARD_TO,
    new_shard => $SHARD_FROM,
    wanted_start_time__dont_quote => 'NOW()',
});

$log->out('FINISH');
