#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr

{
  type => 'script',
  when => 'after',
  comment => '
- по умолчанию запускать без ппараметров
- можно запускать повторно;
- если один из ppcstatов недоступен, можно запускать выборочно на наборе работающих хостов (--host ppcstat:5 --host ppcstat:6), а затем на проблемном;',
  time_estimate => "1-30 минут (зависит от локов в базе)",
}

=cut

use strict;
use warnings;

use my_inc "..";

use Settings;
use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;
use ScriptHelper;

use DBStat;

use Time::HiRes qw/gettimeofday tv_interval/;

use utf8;

my $BORDER_DATE = '2014-11-01'; # дата, начиная с которой статистика детализируется по DeviceType
my $TIME_WAIT_FOR_FREE_LOCK = 15*60; # в течение скольки секунд пытаемся попасть на момент когда каждый из заказов не залочен

my @ppcstat_hosts;
extract_script_params(
    'host=s@' => \@ppcstat_hosts,
) || exit(1);
if (!@ppcstat_hosts) {
    @ppcstat_hosts = sort DBStat->get_db_hosts("");
}

$log->out('START');
$log->out("Working on hosts:", \@ppcstat_hosts);

for my $ppcstat_host (@ppcstat_hosts) {
    $log->msg_prefix("[$ppcstat_host]");

    $log->out("start processing host");
    my $dbh_stat = connect_db( $ppcstat_host );

    my $oids = get_hash_sql($dbh_stat, 'select OrderID
                                          from order_stat_info
                                         where statEnd >= ? AND (syncTime > ? or statTime > ?)',
                                               $BORDER_DATE, $BORDER_DATE, $BORDER_DATE);
    my $updated_qty = 0;
    $log->out("trying to update orders: " . join(',', keys %$oids));

    my $t0 = [gettimeofday];
    while (keys %$oids) {
        foreach my $oid (keys %$oids) {
            my $is_locked = get_one_field_sql($dbh_stat, qq/SELECT IS_USED_LOCK('REFRESH_$oid')/);
            next if $is_locked;

            my $is_updated = do_sql($dbh_stat, [qq/
                            UPDATE order_stat_info
                               SET statTime=LEAST(statTime, ?)/,
                             WHERE => { OrderID => $oid}], $BORDER_DATE);
            $updated_qty += $is_updated;
            delete $oids->{$oid};
        }
        last if tv_interval($t0) >= $TIME_WAIT_FOR_FREE_LOCK;
        sleep(5) if keys %$oids; # пауза чтоб не частить с запросами в БД
    }

    $log->out("updated $updated_qty orders");
    $log->out("unable to lock orders: " . join(',', keys %$oids)) if keys %$oids;

    $log->out("finish processing host");
}

