#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by mirage
# .migr
[
  {
    type => 'sql',
    webstop => "0",
    db => "ppc:all",
    when => 'before',
    time_estimate => "1 секундa",
    sql => "CREATE TABLE clients_api_options (
        `ClientID`      int(10) unsigned NOT NULL PRIMARY KEY,
        `api_enabled`   enum('Yes','No','Default') NOT NULL DEFAULT 'Default'
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8"
  },
  {
    type => 'script',
    when => 'after',
    time_estimate => "2 минута",
    comment => "переносим данные из колонки api_enabled
                таблицы users_api_options в таблицу clientиs_api_options"
  },


]

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Retry;
use ShardingTools;

use Settings;
use ScriptHelper;

$log->out('START');

do_in_transaction{
    for my $shard (ppc_shards()) {
        do_insert_select_sql(PPC(shard=>$shard),
            "INSERT INTO clients_api_options (ClientID, api_enabled) VALUES %s
             ON DUPLICATE KEY UPDATE
             api_enabled=if( api_enabled='Yes' or (api_enabled='No' and VALUES(api_enabled)='Default')
                            , api_enabled
                            , VALUES(api_enabled)
                        )",
            "SELECT u.ClientID, uo.api_enabled FROM users_api_options uo inner join users u on uo.uid=u.uid",
            sleep_coef => 1
        );
    }
};
$log->out('FINISH');
