#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
[
{
  type => 'sql',
  webstop => "0",
  db => "ppc:all",
  when => 'before',
  time_estimate => "2.5 часа на devtest через pt-osc",
  comment => 'если делать альтер через pt-osc - нужно добавить параметр --no-check-alter',
  sql => "alter table bids_href_params add column cid int unsigned not null default 0 first, add unique index (id), drop primary key, add primary key (cid, id)"
},
{
  type => 'script',
  when => 'after',
  time_estimate => "48 часов",
  comment => "можно перезапускать, для ускорения можно указывать в параметре --cid-from последний cid из лога
на ТС можно не ждать окончания работы скрипта перед началом тестирования
"
}
]

=cut

use warnings;
use strict;
use utf8;

use List::UtilsBy qw/partition_by/;
use List::Util qw/max/;

use Yandex::Retry qw/relaxed/;
use Yandex::ListUtils qw/chunks nsort/;
use Yandex::DBTools;

use Settings;
use ShardingTools;
use ScriptHelper;

my $SLEEP_COEF = 1;
my $CID_FROM = 1;
my @SHARDS;
extract_script_params(
    'sleep-coef=i' => \$SLEEP_COEF,
    'cid-from=i' => \$CID_FROM,
    'shard-id=i' => \@SHARDS,
    );
@SHARDS = ppc_shards() if !@SHARDS;

$log->out('START');

my $CHUNK_SIZE = 10_000;

my $max_cid = max @{get_one_column_sql(PPC(shard => \@SHARDS), "SELECT max(cid) FROM campaigns")};
my $cnt = 0;
for(my $cid_from = $CID_FROM; $cid_from <= $max_cid; $cid_from+=$CHUNK_SIZE) {
    for my $shard (@SHARDS) {
        $log->out("cid_from: $cid_from, shard: $shard");
        my $id2cid = get_hash_sql(PPC(shard=>$shard), "
                        SELECT STRAIGHT_JOIN bi.id, bi.cid
                          FROM bids bi JOIN bids_href_params bph using (id)
                         WHERE bph.cid = 0 AND bi.cid between ? AND ?
                        UNION ALL
                        SELECT STRAIGHT_JOIN bi.id, bi.cid
                          FROM bids_arc bi JOIN bids_href_params bph using (id)
                         WHERE bph.cid = 0 AND bi.cid between ? AND ?
                        ", $cid_from, $cid_from+$CHUNK_SIZE-1
                         , $cid_from, $cid_from+$CHUNK_SIZE-1
                );
        my %cid2ids = partition_by {$id2cid->{$_}} keys %$id2cid;
        while(my ($cid, $ids) = each %cid2ids) {
            for my $ids_chunk (chunks [nsort @$ids], $CHUNK_SIZE) {
                $log->out({cid=>$cid, ids=>$ids_chunk});
                relaxed times => $SLEEP_COEF, sub {
                    $cnt += do_update_table(PPC(shard => $shard), "bids_href_params", {cid => $cid}, where => {id => $ids_chunk});
                };
            }
        }
    }
}

$log->out("FINISH, $cnt rows updates");

