#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
[
  {
    type => 'sql',
    webstop => "0",
    db => "ppc:all",
    when => 'before',
    time_estimate => "1 сек",
    sql => "
CREATE TABLE `when_money_on_camp_was` (
  `cid` int unsigned NOT NULL,
  `interval_start` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `interval_end` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`cid`,`interval_end`)
) ENGINE=InnoDB
"
  },
  {
    type => 'script',
    when => 'after',
    time_estimate => "10 минут",
    comment => "можно перезапускать"
  }
]

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::DBShards;
use ShardingTools;

use Settings;
use ScriptHelper;

$log->out('START');
my $CID_FROM = 0;
extract_script_params(
    "cid-from=i" => \$CID_FROM
    );

my ($cid, $time) = ($CID_FROM, '0000-00-00');
my $finish = 0;
while(!$finish) {
    do_in_transaction {
        my $sth = exec_sql(MONITOR, "SELECT cid, interval_start, interval_end from when_money_on_camp_was where cid >= ? and (cid > ? or interval_end > ?) order by cid, interval_end limit 10000 FOR UPDATE", $cid, $cid, $time);
        my $data = $sth->fetchall_arrayref();
        if (!@$data) {
            $finish = 1;
            return;
        }
        $log->out("from $cid, $time");
        foreach_shard cid => $data, by => sub {$_->[0]}, chunk_size => 1_000, sub {
            my ($shard, $data_chunk) = @_;
            do_mass_insert_sql(PPC(shard => $shard), "INSERT IGNORE INTO when_money_on_camp_was (cid, interval_start, interval_end) VALUES %s", $data_chunk);
        };
        ($cid, $time) = @{$data->[-1]}[0, 2];
    };
}

$log->out('FINISH');

