#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr

{
  type => 'script',
  when => 'after',
  time_estimate => "1-2 минуты",
  comment => "Вносим изменения в RBAC и ppc. При падении с ошибкой - второй раз запускать, без детального изучения что успело поменяться, НЕ СЛЕДУЕТ."
}

=cut

use strict;
use warnings;

use my_inc "..";

use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Balance;
use ScriptHelper;

use Client;

use RBAC2::Extended;
use RBACDirect;

use utf8;

my $main_client_id = 478255;
my $second_client_id = 333412;
my @CLIENT_IDS = ($main_client_id, $second_client_id);

my $chief_rep_uid = 81663181;

# +-----------+----------+
# | uid       | ClientID |
# +-----------+----------+
# |  81663181 |   478255 |
# | 272581716 |   333412 |
# | 274239803 |   333412 |
# +-----------+----------+
my %rep_uids = ($main_client_id => [81663181],
                $second_client_id => [272581716,274239803]);

my $operator_uid = 1;

$log->out('START');

# объединяем клиентов в rbac в обратную сторону, перед этим создав клиента 478255 с представителем в rbac
$log->out('remerge clients in RBAC');
my $rbac = eval { RBAC2::Extended->get_singleton( $operator_uid ) } || $log->die("Can't init RBAC");

my $buffer_rep_uid = $rep_uids{$second_client_id}->[0];
# "освобождаем" $chief_rep_uid
$log->die("rbac_switch_client_chief(\$rbac, $buffer_rep_uid) failed") if rbac_switch_client_chief($rbac, $buffer_rep_uid);
$log->die("rbac_drop_client_rep(\$rbac, $second_client_id, $chief_rep_uid) failed") if rbac_drop_client_rep($rbac, $second_client_id, $chief_rep_uid);
# создаем основного клиента - 478255 с представителем $chief_rep_uid
$log->die("rbac_create_client(\$rbac, $chief_rep_uid) failed") if rbac_create_client($rbac, $chief_rep_uid);
# объединяем клиентов в RBAC
$log->die("rbac_merge_clients(\$rbac, $main_client_id, $second_client_id)") if rbac_merge_clients($rbac, $main_client_id, $second_client_id);

$log->out('remerge clients in RBAC finished');

set_main_client_id(\@CLIENT_IDS);

$log->out('FINISH');


sub set_main_client_id
{
    my $client_ids = shift;

    return if ref($client_ids) ne 'ARRAY' || ! @$client_ids;

    for my $client_id (@$client_ids) {

        next if $main_client_id == $client_id;

        do_update_table(PPC(ClientID => $client_id), 'users', {ClientID => $main_client_id}, where => {ClientID => $client_id});

        # нужно проапдейтить адреса в vcards и удалить дубликаты из addresses
        merge_clients_addresses($main_client_id, $client_id);

        # переносим условия ретаргетинга на итогового клиента
        change_retargetings_clientid($main_client_id, $client_id);

        # переносим сайт-линки
        change_sitelinks_clientid($main_client_id, $client_id);

        # переносим минус-слова
        change_minuswords_clientid($main_client_id, $client_id);

        # update overdraft
        # лочимся, чтобы во время переноса суммы у клиентов не могли измениться валюты
        my $lock_guard_source = Client::get_per_client_convert_lock_guard($client_id);
        my $lock_guard_target = Client::get_per_client_convert_lock_guard($main_client_id);

        my $is_main_client_exist = get_one_field_sql(PPC(ClientID => $main_client_id), "select 1 from clients_options where ClientID = ?", $main_client_id);
        my $is_client_exist = get_one_field_sql(PPC(ClientID => $client_id), "select 1 from clients_options where ClientID = ?", $client_id);

        if ($is_main_client_exist && $is_client_exist) {
            # удаляем старые данные
            do_sql(PPC(ClientID => $client_id), "delete from clients_options where ClientID = ?", $client_id);
        } elsif(!$is_main_client_exist && $is_client_exist) {
            my $client_data = get_one_line_sql(PPC(ClientID => $client_id), "
                select balance_tid, overdraft_lim, debt,
                       nextPayDate, statusBalanceBanned, warned_nextPayDate, warned_interval,
                       discount, budget, border_next, discount_next, border_prev
                from clients_options
                where ClientID = ?", $client_id
            );
            $client_data->{ClientID} = $main_client_id;

            do_insert_into_table(PPC(ClientID => $main_client_id), 'clients_options', $client_data);
            do_sql(PPC(ClientID => $client_id), "delete from clients_options where ClientID = ?", $client_id);
        }

        undef $lock_guard_source;
        undef $lock_guard_target;

        update_shard_chain('ClientID', $client_id, $main_client_id);

        Yandex::Log
          ->new(%Yandex::Balance::BALANCE_CALLS_LOG_SETTINGS, msg_prefix => 'set_main_client_id:')
          ->out("new ClientID: $main_client_id, old ClientID: $client_id");
    }

    return 1;
}

sub merge_clients_addresses {
    my ($main_client_id, $second_client_id) = @_;

    my $all_addresses_data = get_all_sql(PPC(ClientID => $second_client_id), [
        'SELECT aid, address, ClientID FROM addresses', WHERE => { ClientID => [$main_client_id, $second_client_id] }
    ]);
    my %all_addresses;
    for my $row (@$all_addresses_data) {
        $all_addresses{ $row->{address} }->{ $row->{ClientID} } = $row->{aid};
    }
    for my $address (keys %all_addresses) {
        if (scalar( keys %{$all_addresses{$address}} ) == 1 && exists $all_addresses{$address}->{$main_client_id}) {
            # только один адрес и тот на новый ClientID, пропускаем
            next;
        } elsif (scalar( keys %{$all_addresses{$address}} ) == 1 && exists $all_addresses{$address}->{$second_client_id}) {
            # только один адрес и тот на старый ClientID, апдейтим только addresses
            do_update_table(PPC(ClientID => $second_client_id), 'addresses', {ClientID => $main_client_id},
                            where => {ClientID => SHARD_IDS, aid=>$all_addresses{$address}->{$second_client_id}});
        } elsif (scalar( keys %{$all_addresses{$address}} ) == 2) {
            # на старом и новом клиенте есть 2 одинаковых адреса, для старого удаляем из addresses и апдейтим vcards
            do_delete_from_table(PPC(ClientID => $second_client_id), 'addresses',
                            where => {ClientID => SHARD_IDS, aid=>$all_addresses{$address}->{$second_client_id}});
            do_update_table(PPC(ClientID => $second_client_id), 'vcards', {address_id => $all_addresses{$address}->{$main_client_id}},
                                                         where => {address_id => $all_addresses{$address}->{$second_client_id}});
        }
    }
}

sub change_retargetings_clientid {
    my ($main_client_id, $second_client_id) = @_;
    do_update_table(PPC(ClientID => $second_client_id), 'retargeting_conditions'
                           , {ClientID => $main_client_id}
                           , where => {ClientID => $second_client_id}
                       );
}

sub change_sitelinks_clientid {
    my ($main_client_id, $second_client_id) = @_;

    do_update_table(PPC(ClientID => $second_client_id), 'sitelinks_sets', {ClientID => $main_client_id},
        where => {ClientID => $second_client_id}
    );
}

sub change_minuswords_clientid {
    my ($main_client_id, $second_client_id) = @_;

    do_update_table(PPC(ClientID => $second_client_id), 'minus_words', {ClientID => $main_client_id},
        where => {ClientID => $second_client_id}
    );
}
