#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'минута',
  comment => 'Удаляем ошибочно проставленные тизеры российским клиентам, которые должны без копирования конвертироваться',
}

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;

use Settings;
use ScriptHelper;
use ShardingTools;

$log->out('START');

for my $shard (ppc_shards()) {
    $log->msg_prefix("[shard $shard]");
    $log->out("Fetching clients with wrong teaser");
    my $data = get_all_sql(PPC_HEAVY(shard => $shard), ['
        SELECT ctfmt.*
        FROM clients_to_force_multicurrency_teaser ctfmt
        INNER JOIN client_nds cn ON cn.ClientID = ctfmt.ClientID AND NOW() > cn.date_from and NOW() < cn.date_to
        INNER JOIN client_firm_country_currency cfcc ON ctfmt.ClientID = cfcc.ClientID
        LEFT JOIN currency_convert_queue q ON q.ClientID = ctfmt.ClientID
        WHERE
                ctfmt.modify_convert_allowed = 0
            AND cn.nds = 18
            AND q.ClientID IS NULL
        GROUP BY ctfmt.ClientID
        HAVING COUNT(*) = 1 AND MAX(cfcc.currency) = "RUB"
    ']);
    my $clients_cnt = scalar(@$data);
    $log->out("Got $clients_cnt clients to remove teaser");
    if ($clients_cnt > 0) {
        for my $row (@$data) {
            $log->out($row);
        }
        my @clientids = map { $_->{ClientID} } @$data;
        $log->out("Removing teaser for ClientIDs:", \@clientids);
        my $rows_cnt = do_delete_from_table(PPC(shard => $shard), 'clients_to_force_multicurrency_teaser', where => {ClientID => \@clientids});
        $log->out("Deleted $rows_cnt teaser rows");
    }
}

$log->out('FINISH');
