#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
[
  {
    type => 'sql',
    webstop => "0",
    db => "ppc:all",
    when => 'after',
    time_estimate => "1 sec",
    sql => "alter table bids_href_params drop index id",
    comment => q!
На ТС альтеры нужно выполнить перед тестированием - попробуем отловить неисправленные запросы
После выкладки релиза в прод - сначала сделать на 6-ом шарде, и подождать сутки
если всё нормально - можно делать на всех шардах.
!,
  },
  {
    type => 'script',
    when => 'after',
    time_estimate => "4 часа",
    comment => "обрабатывает все шарды параллельно"
  }
]

=cut

use warnings;
use strict;
use utf8;

use JSON;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Retry;

use Settings;
use ScriptHelper 'Yandex::Log' => [date_suf => "%Y%m%d", auto_rotate => 1, lock => 1, tee => $ENV{LOG_TEE}];
use ShardingTools;

$log->out('START');

my $SLEEP_COEF = 1;
my $CHUNK_SIZE = 1000;
my @SHARDS;
extract_script_params(
    'sleep-coef=i' => \$SLEEP_COEF,
    'chunk_size=i' => \$CHUNK_SIZE,
    'shard-id=i' => \@SHARDS,
);
@SHARDS = ppc_shards() if !@SHARDS;

foreach_shard_parallel shard => \@SHARDS, sub {
    my ($shard) = @_;
    restart_script_timer();
    $log->msg_prefix("[shard=$shard,pid=$$]");
    while(1) {
        my $ret = relaxed times => 2, sub {
            my $sth = exec_sql(PPC(shard => $shard),
                            "SELECT id, param1, param2 FROM bids_href_params WHERE cid = 0 ORDER BY id LIMIT ?",
                            $CHUNK_SIZE);
            my $rows = $sth->fetchall_arrayref();
            return undef if !@$rows;
            my ($id_from, $id_to) = ($rows->[0]->[0], $rows->[-1]->[0]);
            $log->out("delete rows with cid=0, id between $id_from and $id_to => ".to_json($rows));
            return do_delete_from_table(PPC(shard => $shard), 'bids_href_params', 
                            where => {cid => 0, id__between => [$id_from, $id_to]}
                    );
        };
        last if !defined $ret;
    };
};

$log->out('FINISH');

