#!/usr/bin/perl

# https://st.yandex-team.ru/DIRECT-37721

use my_inc '..';

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '5 sec',
}

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;

use Settings;
use ScriptHelper;
use ShardingTools;

use User;

# --------------------------------------------------------------------
sub main {
    $log->out('START');

    for my $shard (ppc_shards()) {
        $log->msg_prefix("[shard $shard]");
        $log->out("get users");

        # выбираем только внутренних пользователей отключивших показ показателя качества
        my $data = get_all_sql(PPC_HEAVY(shard => $shard), ['
            select uo.uid, uo.options
            from users_options uo
              join internal_users using(uid)
            where uo.options like "%show_quality_score:%"
        ']);
        $log->out({data => $data});
        next unless @$data;

        my $old_options = mass_get_user_options([map {$_->{uid}} @$data]);
        $log->out({old_options => $old_options});

        for my $uid (keys %$old_options) {
            if (defined $old_options->{$uid}->{show_quality_score}) {
                my $options = get_user_options($uid);
                delete $options->{show_quality_score};
                set_user_options($uid, $options);
                $log->out("update uid: $uid");
            }
        }
    }

    $log->out('FINISH');
}

# --------------------------------------------------------------------
main();
