#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
[
  {
    type => 'sql',
    webstop => "0",
    db => "ppc:all",
    when => 'before',
    time_estimate => "2 sec",
    sql => q!CREATE TABLE `events` (
  `eid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  eventobject enum('camp','adgroup','banner','phrase') NOT NULL DEFAULT 'camp',
  eventtype enum('c_start','c_finish','c_status','c_pay','c_autooptimisation','c_autobudget','c_day_budget','b_create','b_text','b_status','b_word','b_category','b_geo','ph_price','ph_autobr','ph_change','c_strategy','ph_price_ctx','b_retargeting','ret_delete','c_pay_multicurrency','c_day_budget_multicurrency','adgr_geo','adgr_word','adgr_retargeting') DEFAULT NULL,
  `eventtime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `objectid` int(10) unsigned NOT NULL DEFAULT '0',
  `objectuid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `uid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `cid` int(10) unsigned NOT NULL DEFAULT '0',
  `json_data` text NOT NULL,
  PRIMARY KEY (`eid`),
INDEX `i_objectuid` (`objectuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
!
  },
  {
    type => 'script',
    when => 'after',
    time_estimate => "несколько секунд",
    comment => "переносим неотправленные события из monitor в ppcdata"
  },
  {
    type => 'sql',
    webstop => "0",
    db => "monitor",
    when => 'after',
    time_estimate => "2 sec",
    sql => "RENAME TABLE events TO events_to_delete"
  }  
]

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::DBShards;

use Settings;
use ScriptHelper;

$log->out('START');

my $rows = exec_sql(MONITOR, "SELECT objectuid, eventobject, eventtype, eventtime, objectid, uid, cid, json_data
                                FROM events
                               WHERE statusSent = 'No'
                ")->fetchall_arrayref();
foreach_shard uid => $rows, by => sub {$_->[0]}, sub {
    my ($shard, $chunk) = @_;
    do_mass_insert_sql(PPC(shard => $shard), 'insert into events (objectuid, eventobject, eventtype, eventtime, objectid, uid, cid, json_data) values %s', $chunk);
};

$log->out('FINISH');

