#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
[
  {
    type => 'sql',
    webstop => "0",
    db => "ppc:all",
    when => 'before',
    time_estimate => "1 sec",
    sql => [
"CREATE TABLE `eventlog` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `eventtime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `type` int(10) unsigned NOT NULL,
  `ClientID` int(10) unsigned NOT NULL,
  `cid` int(10) unsigned NOT NULL DEFAULT '0',
  `bid` int(10) unsigned NOT NULL DEFAULT '0',
  `bids_id` int(10) unsigned NOT NULL DEFAULT '0',
  `params` text,
  PRIMARY KEY (`id`),
  KEY `ClientID_time` (`ClientID`,`eventtime`),
  KEY `eventtime` (`eventtime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
",
"CREATE TABLE `push_notifications_process` (
  `notification_id` int(10) unsigned NOT NULL,
  `event_id` bigint(20) unsigned NOT NULL,
  `rank` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`notification_id`,`event_id`),
  KEY `event_id` (`event_id`),
  FOREIGN KEY (`notification_id`) REFERENCES `users_notifications` (`notification_id`) ON DELETE CASCADE,
  FOREIGN KEY (`event_id`) REFERENCES `eventlog` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8",
]
  },
  {
    type => 'script',
    when => 'after',
    time_estimate => "24 часа",
    comment => "можно перезапускать"
  }
]

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::DBShards;

use Settings;
use ScriptHelper;
use HashingTools qw/md5_hex_utf8/;

$log->out('START');

my $CHUNK_SIZE = 10_000;

my $max_time = get_one_field_sql(MONITOR, "SELECT max(eventtime) FROM eventlog");
my @fields = qw/ClientID eventtime type cid bid bids_id params/;
my $fields_sql = join ',', @fields;

my ($last_time, $last_id) = ('0000-00-00', 0);
while(1) {
    $log->out("start with last_time=$last_time, last_id=$last_id");
    my $rows = get_all_sql(MONITOR, "
                        SELECT id, $fields_sql
                          FROM eventlog
                         WHERE eventtime between ? and ?
                               AND (eventtime > ? OR id > ?)
                         ORDER BY eventtime, id
                         LIMIT $CHUNK_SIZE", $last_time, $max_time, $last_time, $last_id);
    foreach_shard ClientID => $rows, with_undef_shard => 1, sub {
        my ($shard, $chunk) = @_;
        $log->out("shard ".($shard//'undef').", rows number ".scalar(@$chunk));
        if (!$shard) {
            $log->out("Unknown shard for " => $chunk);
            return;
        }
        my %was = map {_hash_event($_) => 1} @{get_all_sql(PPC(shard => $shard), "
                        SELECT $fields_sql
                          FROM eventlog
                         WHERE eventtime between ? and ?
                      ", $rows->[0]->{eventtime}, $rows->[-1]->{eventtime})};
        my @to_insert = map { [ @{$_}{@fields} ] } 
                        grep { !$was{_hash_event($_)} } 
                        @$chunk;
        $log->out("Skip ".(scalar(@$chunk) - scalar(@to_insert))." duplicate rows for shard $shard");
        my $cnt = do_mass_insert_sql(PPC(shard => $shard), "INSERT INTO eventlog ($fields_sql) VALUES %s", \@to_insert);
        $log->out("Inserted $cnt rows");
        
    };
    last if @$rows < $CHUNK_SIZE;
    ($last_time, $last_id) = @{$rows->[-1]}{'eventtime', 'id'};
}

$log->out('FINISH');


sub _hash_event {
    my ($e) = @_;
    return md5_hex_utf8(join '|', map {$e->{$_}//'UNDEF'} @fields);
}

