#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
[
  {
    type => 'sql',
    webstop => "0",
    db => "ppc:all",
    when => 'before',
    time_estimate => "1 sec",
    sql => "CREATE TABLE `fraud_clicks` (
  `OrderID` int(10) unsigned NOT NULL,
  `stat_date` date NOT NULL,
  `clicks` int(10) NOT NULL,
  `gift_clicks` int(10) NOT NULL,
  PRIMARY KEY (`OrderID`,`stat_date`),
  KEY `stat_date` (`stat_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
/*!50100 PARTITION BY RANGE (YEAR(stat_date))
(PARTITION p2007 VALUES LESS THAN (2008) ENGINE = InnoDB,
 PARTITION p2008 VALUES LESS THAN (2009) ENGINE = InnoDB,
 PARTITION p2009 VALUES LESS THAN (2010) ENGINE = InnoDB,
 PARTITION p2010 VALUES LESS THAN (2011) ENGINE = InnoDB,
 PARTITION p2011 VALUES LESS THAN (2012) ENGINE = InnoDB,
 PARTITION p2012 VALUES LESS THAN (2013) ENGINE = InnoDB,
 PARTITION p2013 VALUES LESS THAN (2014) ENGINE = InnoDB,
 PARTITION p2014 VALUES LESS THAN (2015) ENGINE = InnoDB,
 PARTITION p2015 VALUES LESS THAN (2016) ENGINE = InnoDB,
 PARTITION p2016 VALUES LESS THAN (2017) ENGINE = InnoDB,
 PARTITION p2017 VALUES LESS THAN (2018) ENGINE = InnoDB,
 PARTITION p2018 VALUES LESS THAN (2019) ENGINE = InnoDB,
 PARTITION p2019 VALUES LESS THAN (2020) ENGINE = InnoDB,
 PARTITION p2020 VALUES LESS THAN (2021) ENGINE = InnoDB,
 PARTITION p2021 VALUES LESS THAN (2022) ENGINE = InnoDB,
 PARTITION p2022 VALUES LESS THAN (2023) ENGINE = InnoDB,
 PARTITION p2023 VALUES LESS THAN (2024) ENGINE = InnoDB,
 PARTITION p2024 VALUES LESS THAN MAXVALUE ENGINE = InnoDB) */
"
  },
  {
    type => 'script',
    when => 'after',
    time_estimate => "6 часов",
    comment => "можно перезапускать"
  }
]

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::DBShards;

use Settings;
use ScriptHelper;

$log->out('START');

my $SELECT_SIZE = 100_000;

my ($OrderID, $stat_date) = (0, '0000-00-00');
while(1) {
    $log->out("Start select OrderID=$OrderID, stat_date=$stat_date");
    my $rows = exec_sql(PPCORDSTAT, "
                          SELECT OrderID, stat_date, clicks, gift_clicks
                            FROM fraud_clicks
                           WHERE OrderID >= ? AND (OrderID > ? OR stat_date > ?)
                           ORDER BY OrderID, stat_date
                           LIMIT $SELECT_SIZE", $OrderID, $OrderID, $stat_date
        )->fetchall_arrayref();
    $log->out("selected ".scalar(@$rows)." rows");
    foreach_shard OrderID => $rows, by => sub {$_->[0]}, sub {
        my ($shard, $chunk) = @_;
        $log->out("shard $shard, chunk_size ".scalar(@$chunk));
        my $cnt = do_mass_insert_sql(PPC(shard=>$shard), "INSERT IGNORE INTO fraud_clicks (OrderID, stat_date, clicks, gift_clicks) VALUES %s", $chunk);
        $log->out("inserted $cnt rows");
    };
    last if @$rows != $SELECT_SIZE;
    ($OrderID, $stat_date) = @{$rows->[-1]};
}

$log->out('FINISH');

